<?php
// admin/exam_structure_process.php - Handles saving Max and Passing Marks

session_start();
// Output buffering shuru karein taaki redirection mein problem na aaye
ob_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include_once('../config/db.php');
$conn = getDBConnection();

// Function for safe redirection
function redirect($page, $params, $msg = '', $type = 'success') {
    $param_name = ($type === 'success') ? 'msg' : 'err';
    $params[$param_name] = urlencode($msg);
    $url = $page . '?' . http_build_query($params);
    header("Location: $url");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'save_exam_structure') {
    $exam_id = (int)($_POST['exam_id'] ?? 0);
    $class_id = (int)($_POST['class_id'] ?? 0);
    $subjects = $_POST['subjects'] ?? [];

    $redirect_page = 'exam_structure.php';
    $redirect_params = [
        'exam_id' => $exam_id,
        'class_id' => $class_id
    ];

    if (!$exam_id || !$class_id || empty($subjects)) {
        redirect($redirect_page, $redirect_params, 'Incomplete data received. Cannot save structure.', 'danger');
    }

    $saved_count = 0;
    
    try {
        $conn->begin_transaction();

        foreach ($subjects as $subject_id => $data) {
            $subject_id = (int)$subject_id;
            $total_marks = (int)($data['total'] ?? 0);
            $passing_marks = (int)($data['passing'] ?? 0);

            if ($total_marks <= 0) {
                $conn->rollback();
                redirect($redirect_page, $redirect_params, "Error: Total Marks for Subject ID {$subject_id} must be greater than 0.", 'danger');
            }
            if ($passing_marks > $total_marks) {
                $conn->rollback();
                redirect($redirect_page, $redirect_params, "Error: Passing Marks for Subject ID {$subject_id} cannot exceed Total Marks.", 'danger');
            }

            // UPSERT Query: UNIQUE KEY set hone par yeh update karega agar row pehle se hai
            $sql = "
                INSERT INTO class_exam_structure 
                    (exam_id, class_id, subject_id, total_marks, passing_marks)
                VALUES (?, ?, ?, ?, ?)
                ON DUPLICATE KEY UPDATE
                    total_marks = VALUES(total_marks),
                    passing_marks = VALUES(passing_marks)
            ";

            $stmt = $conn->prepare($sql);
            $stmt->bind_param("iiiii", $exam_id, $class_id, $subject_id, $total_marks, $passing_marks);
            
            if (!$stmt->execute()) {
                $conn->rollback();
                redirect($redirect_page, $redirect_params, 'Database Error: Could not save structure for subject ' . $subject_id . '. ' . $conn->error, 'danger');
            }
            $saved_count++;
            $stmt->close();
        }

        $conn->commit();
        redirect($redirect_page, $redirect_params, "Successfully saved structure for {$saved_count} subjects.", 'success');

    } catch (Exception $e) {
        $conn->rollback();
        redirect($redirect_page, $redirect_params, 'An unexpected error occurred: ' . $e->getMessage(), 'danger');
    }
} else {
    redirect('dashboard.php', [], 'Invalid request method or action.', 'danger');
}

$conn->close();
ob_end_flush();
?>