<?php
// admin/fee_head_edit.php
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();
$head_id = (int)($_GET['id'] ?? 0);
$head = null;
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

if ($head_id > 0) {
    $stmt = $conn->prepare("SELECT * FROM fee_heads WHERE id = ?");
    $stmt->bind_param("i", $head_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $head = $result->fetch_assoc();
    $stmt->close();
}

$conn->close();

if (!$head) {
    // Agar ID valid nahi ya head nahi mila, wapas fees_config par bhej dein
    header('Location: fees_config.php?err=' . urlencode('Invalid Fee Head ID.'));
    exit;
}
?>

<h1 class="mb-4">Edit Fee Head/Discount: <?php echo htmlspecialchars($head['name']); ?></h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card p-4">
    <form action="fees_process.php" method="POST">
        <input type="hidden" name="action" value="edit_head">
        <input type="hidden" name="head_id" value="<?php echo $head['id']; ?>">
        
        <div class="form-group">
            <label>Name:</label>
            <input type="text" name="name" class="form-control" value="<?php echo htmlspecialchars($head['name']); ?>" required>
        </div>
        
        <div class="form-group">
            <label>Type:</label>
            <select name="type" class="form-control" required>
                <option value="fee" <?php echo ($head['type'] == 'fee') ? 'selected' : ''; ?>>Fee Head (Charges)</option>
                <option value="discount" <?php echo ($head['type'] == 'discount') ? 'selected' : ''; ?>>Discount/Concession</option>
                <option value="fine" <?php echo ($head['type'] == 'fine') ? 'selected' : ''; ?>>Fine/Penalty</option>
            </select>
        </div>
        
        <div class="form-group">
            <label>Recurring (Monthly/Term):</label>
            <select name="is_recurring" class="form-control">
                <option value="1" <?php echo ($head['is_recurring'] == 1) ? 'selected' : ''; ?>>Yes (Har mahine/term mein shamil hoga)</option>
                <option value="0" <?php echo ($head['is_recurring'] == 0) ? 'selected' : ''; ?>>No (One-Time / Sirf zaroorat par)</option>
            </select>
        </div>
        
        <button type="submit" class="btn btn-success">Update Head</button>
        <a href="fees_config.php?tab=heads" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php
include_once('includes/footer.php'); 
?>