<?php
// admin/includes/header.php - Final Code (License Check Added)

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !isset($_SESSION['is_admin_logged_in'])) {
    header('Location: login.php');
    exit;
}

if (!file_exists('../config/db.php')) {
    header('Location: ../install/index.php');
    exit;
}
include_once('../config/db.php');

$conn = getDBConnection();

// ====================================================================
// ✅ LICENSE EXPIRY CHECK LOGIC (NEW BLOCK)
// ====================================================================
if (isset($_SESSION['user_id']) && $conn) {
    $user_id = (int)$_SESSION['user_id'];
    $today = date('Y-m-d');
    
    // 1. Fetch license data
    $check_stmt = $conn->prepare("SELECT license_status, license_expiry_date FROM users WHERE id = ?");
    $check_stmt->bind_param("i", $user_id);
    $check_stmt->execute();
    $license_data = $check_stmt->get_result()->fetch_assoc();
    // $check_stmt->close(); // Connection close abhi nahi hoga
    
    if ($license_data) {
        $expiry_date = $license_data['license_expiry_date'];
        $current_status = $license_data['license_status'];
        
        // 2. EXPIRY CHECK: Agar license Active hai AUR aaj ki date expiry date ke barabar ya aage hai
        if ($current_status === 'Active' && $expiry_date !== null && $today >= $expiry_date) {
            
            // Status ko 'Expired' set karo (Database mein update)
            $update_stmt = $conn->prepare("UPDATE users SET license_status = 'Expired' WHERE id = ?");
            $update_stmt->bind_param("i", $user_id);
            $update_stmt->execute();
            $update_stmt->close();
            
            $current_status = 'Expired'; // Status update for redirection
        }
        
        // 3. BLOCK ACCESS & REDIRECT: Agar status 'Active' nahi hai, to rok do
        if ($current_status !== 'Active') {
            session_destroy();
            // Redirect to the login page (index.php) with an expiry message
            header("Location: ../index.php?err=" . urlencode("LICENSE EXPIRED: Please contact the service provider to renew your license."));
            exit; 
        }
    }
    $check_stmt->close(); // Statement close karo
}
// ====================================================================


$settings = [];
$result = $conn->query("SELECT setting_key, setting_value FROM settings");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}
$conn->close(); 

// --- Variable Definitions ---
$institute_name = $settings['institute.name'] ?? 'IMS';
$current_user_name = $_SESSION['name'] ?? 'System Admin';
$user_role_id = $_SESSION['role_id'] ?? 1;          
$current_user_role_name = ($user_role_id == 1) ? 'Admin' : 'User'; 

// 🔑 Logo Path definition
$logo_path = !empty($settings['institute.logo_path'] ?? '') ? '../' . $settings['institute.logo_path'] : '../assets/img/logo.png';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($institute_name); ?> - Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    
    <style>
        body { background-color: #f8f9fa; }
        .wrapper { display: flex; min-height: 100vh; }
        #sidebar { 
            min-width: 250px; 
            max-width: 250px; 
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            color: #495057;
            transition: all 0.3s; 
            box-shadow: 2px 0 15px rgba(0,0,0,0.08);
            position: sticky;
            top: 0;
            z-index: 1000;
            border-right: 1px solid #e9ecef;
        }
        #content { width: 100%; padding: 30px; background-color: #f8f9fa; }
        
        /* Sidebar Header Styling */
        .sidebar-header {
            background: linear-gradient(135deg, #2c3e50 0%, #3498db 100%) !important;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        /* Sidebar Menu Styling */
        .list-unstyled a, .list-unstyled a[aria-expanded="false"] { 
            padding: 12px 20px; 
            display: block; 
            color: #495057; 
            text-decoration: none; 
            font-size: 0.95em;
            border-radius: 0 8px 8px 0;
            margin: 2px 10px;
            border-left: 3px solid transparent;
            transition: all 0.3s ease;
            font-weight: 500;
        }
        .list-unstyled a:hover, .list-unstyled a.active { 
            color: #0d6efd; 
            background: rgba(13, 110, 253, 0.08);
            border-left-color: #0d6efd;
            transform: translateX(3px);
        }
        .list-unstyled a i { 
            margin-right: 12px; 
            width: 20px; 
            text-align: center; 
            color: #6c757d;
            transition: all 0.3s ease;
        }
        .list-unstyled a:hover i {
            color: #0d6efd;
            transform: scale(1.1);
        }
        
        /* Submenu */
        ul.collapse a {
            padding-left: 50px !important;
            background: transparent;
            color: #6c757d;
            font-size: 0.9em !important;
            margin: 1px 5px;
            border-left: none;
            position: relative;
        }
        ul.collapse a::before {
            content: '';
            position: absolute;
            left: 35px;
            top: 50%;
            transform: translateY(-50%);
            width: 5px;
            height: 5px;
            background: #0d6efd;
            border-radius: 50%;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        ul.collapse a:hover {
            background: rgba(13, 110, 253, 0.06) !important;
            color: #0d6efd;
            padding-left: 52px !important;
        }
        ul.collapse a:hover::before {
            opacity: 1;
        }
        
        /* Active Submenu Item */
        ul.collapse a.active {
            background: rgba(13, 110, 253, 0.1) !important;
            color: #0d6efd;
            font-weight: 500;
        }
        ul.collapse a.active::before {
            opacity: 1;
        }
        
        /* Headings */
        .sidebar-heading {
            font-size: 0.75rem;
            color: #6c757d; 
            padding: 15px 20px 5px 20px;
            text-transform: uppercase;
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        
        /* Dropdown Arrow */
        .list-unstyled a[data-toggle="collapse"] {
            position: relative;
            padding-right: 45px;
        }
        .list-unstyled a[data-toggle="collapse"]::after {
            content: '\f107';
            font-family: 'Font Awesome 5 Free';
            font-weight: 900;
            border: none;
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            transition: all 0.3s ease;
            color: #6c757d;
            font-size: 13px;
        }
        .list-unstyled a[data-toggle="collapse"][aria-expanded="true"]::after {
            transform: translateY(-50%) rotate(-180deg);
            color: #0d6efd;
        }
        
        /* User Info Section */
        .sidebar-user {
            background: transparent !important;
        }
        .sidebar-user .bg-info {
            background: linear-gradient(135deg, rgba(13, 110, 253, 0.1) 0%, rgba(108, 117, 125, 0.05) 100%) !important;
            border: 1px solid rgba(13, 110, 253, 0.1);
            border-radius: 8px;
        }
        .sidebar-user .text-white {
            color: #495057 !important;
        }
        .sidebar-user .badge-light {
            background-color: #0d6efd !important;
            color: white !important;
        }
        
        /* Logout Button Special Styling */
        .list-unstyled li:last-child a {
            background: rgba(220, 53, 69, 0.08);
            color: #dc3545;
            border-left-color: #dc3545;
            margin: 10px 15px 0 15px;
            border-radius: 8px;
            font-weight: 500;
        }
        .list-unstyled li:last-child a:hover {
            background: rgba(220, 53, 69, 0.15);
            color: #dc3545;
            border-left-color: #dc3545;
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            #sidebar {
                min-width: 220px;
                max-width: 220px;
            }
            .list-unstyled a, .list-unstyled a[aria-expanded="false"] {
                padding: 10px 15px;
                font-size: 0.9em;
            }
            ul.collapse a {
                padding-left: 40px !important;
            }
            ul.collapse a:hover {
                padding-left: 42px !important;
            }
        }
    </style>
</head>
<body>
<div class="wrapper">
    <nav id="sidebar">
        
        <div class="sidebar-header text-center p-3">
            <img 
                src="<?php echo htmlspecialchars($logo_path); ?>" 
                alt="Logo" 
                class="img-fluid mx-auto mb-2" 
                style="
                    max-height: 80px; 
                    width: auto; 
                    border-radius: 50%; 
                    border: 3px solid white; 
                    padding: 3px; 
                    background-color: white; 
                "
            >
            <h5 class="text-white mb-0" style="font-weight: 700; font-size: 1.1rem; line-height: 1.2;">
                <?php echo htmlspecialchars($institute_name); ?>
            </h5>
            <p class="text-light small mb-0" style="opacity: 0.8;">Admin Panel</p>
        </div>

        <div class="sidebar-user p-3" style="padding-top: 10px !important; padding-bottom: 10px !important;">
            <div class="bg-info p-2" style="border-radius: 5px;">
                <p class="text-white small mb-1">
                    <i class="fas fa-user-shield mr-1"></i> Welcome,
                </p>
                <p class="text-white font-weight-bold mb-0" style="font-size: 0.95rem;">
                    <?php echo htmlspecialchars($current_user_name); ?> <span class="badge badge-light ml-1">(Admin)</span>
                </p>
            </div>
        </div>
        <?php include_once('sidebar.php'); ?>
        </nav>
    <div id="content">