<?php
// admin/manage_exams.php - Final Code (List Exams with Safe Edit/Delete)

session_start();
include_once('../config/db.php');
include_once('includes/header.php');

$conn = getDBConnection();

// ------------------------------------------------------------------
// 1. DISPLAY MESSAGES (Aayenge exams_process.php ya add_exam.php se)
// ------------------------------------------------------------------
$message = $_GET['msg'] ?? ''; // Success messages
$error = $_GET['err'] ?? '';   // Error messages

// ------------------------------------------------------------------
// 2. FETCH Exam List
// ------------------------------------------------------------------
$exams_query = "
    SELECT 
        e.id, 
        e.name AS exam_name, 
        s.name AS session_name, 
        e.start_date, 
        e.end_date, 
        e.status
    FROM exams e
    LEFT JOIN academic_sessions s ON e.session_id = s.id
    ORDER BY e.start_date DESC
";

$exams_result = $conn->query($exams_query);
$exams = $exams_result->fetch_all(MYSQLI_ASSOC);

$conn->close();
?>

<h2 class="mb-4">Manage Exams</h2>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card p-4">
    <a href="add_exam.php" class="btn btn-success mb-3" style="width: 150px;">
        <i class="fas fa-plus-circle"></i> Add Exam
    </a>

    <?php if (count($exams) > 0): ?>
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="thead-dark">
                    <tr>
                        <th>ID</th>
                        <th>Exam Name</th>
                        <th>Session</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($exams as $exam): ?>
                        <tr>
                            <td><?php echo $exam['id']; ?></td>
                            <td><?php echo htmlspecialchars($exam['exam_name']); ?></td>
                            <td><?php echo htmlspecialchars($exam['session_name'] ?? 'N/A'); ?></td>
                            <td><?php echo date('d-M-Y', strtotime($exam['start_date'])); ?></td>
                            <td><?php echo $exam['end_date'] ? date('d-M-Y', strtotime($exam['end_date'])) : 'N/A'; ?></td>
                            <td><span class="badge badge-<?php 
                                if ($exam['status'] == 'active') echo 'success';
                                else if ($exam['status'] == 'upcoming') echo 'primary';
                                else if ($exam['status'] == 'completed') echo 'secondary';
                                else echo 'warning';
                            ?>"><?php echo ucfirst($exam['status']); ?></span></td>
                            <td>
                                <a href="edit_exam.php?id=<?php echo $exam['id']; ?>" class="btn btn-sm btn-primary">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                
                                <a href="exam_process.php?action=delete_exam&id=<?php echo $exam['id']; ?>" 
                                   class="btn btn-sm btn-danger" 
                                   onclick="return confirm('WARNING! Are you sure you want to delete this exam? This will permanently delete ALL associated marks, results, and structure data.');">
                                    <i class="fas fa-trash"></i> Delete
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-warning">No exams found in the database.</div>
    <?php endif; ?>

</div>

<?php
include_once('includes/footer.php');
?>