<?php
// admin/manual_admission_form.php - Manual Admission Form for Printing
ob_start();
session_start();

// Check for Print Mode FIRST - before including any other files
$is_print_mode = isset($_GET['mode']) && $_GET['mode'] === 'print';

if (!$is_print_mode) {
    // Only include header and sidebar for NON-print mode
    include_once('../config/db.php');
    include_once('includes/header.php');
    include_once('includes/sidebar.php');
} else {
    // For print mode, only include database connection
    include_once('../config/db.php');
}

// Database Connection
$conn = getDBConnection();

// --- Settings se School Details fetch karna ---
$settings_data = [];
$settings_query = $conn->query("SELECT setting_key, setting_value FROM settings");
if ($settings_query) {
    while ($row = $settings_query->fetch_assoc()) {
        $settings_data[trim($row['setting_key'])] = trim($row['setting_value']);
    }
}

// School Details
$school_name = $settings_data['institute.name'] ?? 'School Name Not Set';
$school_address = $settings_data['institute.address'] ?? 'Address Not Set';
$school_phone = $settings_data['institute.phone'] ?? 'Phone Not Set';
$logo_db_path = $settings_data['institute.logo_path'] ?? '';
$logo_display_url = !empty($logo_db_path) ? '../' . $logo_db_path : '../assets/img/logo.png';

// Current Session fetch karna
$current_session_id = $settings_data['academic.active_session_id'] ?? 1;
$session_query = "SELECT id, name FROM academic_sessions WHERE id = ?";
$session_stmt = $conn->prepare($session_query);
$session_stmt->bind_param("i", $current_session_id);
$session_stmt->execute();
$current_session = $session_stmt->get_result()->fetch_assoc();
$session_stmt->close();

// =========================================================
//            START: Print Mode Rendering
// =========================================================
if ($is_print_mode) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Student Admission Form - <?php echo htmlspecialchars($school_name); ?></title>
    <style>
        /* === PRINT STYLES === */
        @media print {
            @page {
                size: A4;
                margin: 0.7cm;
            }
            body {
                font-family: "Times New Roman", Times, serif;
                font-size: 11pt;
                line-height: 1.3;
                margin: 0;
                padding: 0;
                background: white !important;
                width: 100%;
            }
            .no-print {
                display: none !important;
            }
            /* PRINT MODE MEIN BHI BLACK BOX HEADINGS SHOW HONGE */
            .section-title {
                background-color: #000000 !important;
                color: white !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
        }
        
        /* === GENERAL STYLES === */
        body {
            font-family: Arial, sans-serif;
            font-size: 10pt;
            line-height: 1.3;
            color: #000;
            margin: 0;
            padding: 0;
            background: white;
            width: 100%;
            box-sizing: border-box;
        }
        
        .admission-form-container {
            width: 100%;
            margin: 0 auto;
            padding: 5px;
            box-sizing: border-box;
        }
        
        .school-header {
            text-align: center;
            margin-bottom: 10px;
            border-bottom: 2px solid #333;
            padding-bottom: 8px;
        }
        
        .school-logo {
            max-height: 60px;
            width: auto;
        }
        
        .school-name {
            font-size: 14pt;
            font-weight: bold;
            margin: 2px 0;
        }
        
        .school-address {
            font-size: 9pt;
            margin: 1px 0;
        }
        
        .form-title {
            text-align: center;
            font-size: 13pt;
            font-weight: bold;
            margin: 8px 0;
            text-decoration: underline;
        }
        
        .form-table {
            width: 100%;
            border-collapse: collapse;
            margin: 3px 0;
            font-size: 9pt;
            table-layout: fixed;
        }
        
        .form-table td {
            padding: 5px 5px;
            border: 1px solid #000;
            vertical-align: top;
            word-wrap: break-word;
            overflow: hidden;
            height: 25px;
        }
        
        /* NAYA: Labels ki width kam, fields ki width zyada */
        .form-label {
            font-weight: bold;
            background-color: #f0f0f0;
            width: 20%; /* Pehle 28% tha, ab 20% kar diya */
        }
        
        .form-field {
            width: 30%; /* Pehle 22% tha, ab 30% kar diya - zyada space */
        }
        
        .signature-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 100px;
        }
        
        .signature-table td {
            padding: 25px 5px 5px 5px;
            border: none;
            text-align: center;
            vertical-align: bottom;
            width: 50%;
        }
        
        .signature-line {
            border-top: 1px solid #000;
            padding-top: 2px;
            font-size: 8pt;
        }
        
        .section-title {
            background-color: #000000;
            color: white;
            padding: 3px 6px;
            font-weight: bold;
            margin: 8px 0 3px 0;
            font-size: 9pt;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        
        .photo-space {
            width: 35mm; /* Passport size width */
            height: 45mm; /* Passport size height */
            border: 1px solid #000;
            text-align: center;
            font-size: 7pt;
            background-color: #f9f9f9;
            float: right;
            margin: 3px;
            padding: 2px;
            box-sizing: border-box;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .checkbox-group {
            margin: 2px 0;
        }
        
        .checkbox-group label {
            margin-right: 15px;
            font-weight: normal;
            font-size: 8pt;
        }
        
        .declaration {
            text-align: justify;
            margin: 5px 0;
            font-size: 8pt;
        }
        
        .content-wrapper {
            overflow: hidden;
            width: 100%;
        }
        
        .left-content {
            width: calc(100% - 40mm);
            float: left;
        }
        
        .right-photo {
            width: 40mm;
            float: right;
        }
        
        /* NAYA STYLE: Software Developer Text */
        .developer-text {
            text-align: center;
            margin-top: 20px;
            font-size: 8pt;
            color: #666;
            font-style: italic;
        }
        
        /* NAYA: Address field ke liye extra height */
        .address-field {
            height: 35px !important; /* Zyada height address ke liye */
        }
        
        /* NAYA: Remarks field ke liye extra height */
        .remarks-field {
            height: 40px !important; /* Zyada height remarks ke liye */
        }
    </style>
</head>
<body>
    <div class="admission-form-container">
        <!-- School Header -->
        <div class="school-header">
            <?php if (!empty($logo_display_url)): ?>
            <img src="<?php echo htmlspecialchars($logo_display_url); ?>" alt="School Logo" class="school-logo" onerror="this.style.display='none'">
            <?php endif; ?>
            
            <div class="school-name"><?php echo htmlspecialchars($school_name); ?></div>
            <div class="school-address"><?php echo htmlspecialchars($school_address); ?></div>
            <div class="school-address">Phone: <?php echo htmlspecialchars($school_phone); ?></div>
        </div>
        
        <!-- Form Title -->
        <div class="form-title">STUDENT ADMISSION FORM</div>
        
        <div class="content-wrapper">
            <div class="left-content">
                <!-- Student Information Section - PHOTO KE NEECHE LEFT SIDE -->
                <div class="section-title">ADMISSION INFORMATION</div>
                <table class="form-table">
                    <tr>
                        <td class="form-label">Registration No</td>
                        <td class="form-field"></td>
                        <td class="form-label">Admission Date</td>
                        <td class="form-field"></td>
                    </tr>
                    <tr>
                        <td class="form-label">Academic Session</td>
                        <td align="center" class="form-field"><?php echo htmlspecialchars($current_session['name'] ?? 'Current Session'); ?></td>
                        <td class="form-label">Admission Class</td>
                        <td class="form-field"></td>
                    </tr>
                    <tr>
                        <td class="form-label">Section</td>
                        <td class="form-field"></td>
                        <td class="form-label">Roll Number</td>
                        <td class="form-field"></td>
                    </tr>
                </table>
            </div>
            
            <div class="right-photo">
                <!-- Photo Space - RIGHT SIDE (Passport Size) -->
                <div class="photo-space">
                    Passport Size Photo<br>(35mm x 45mm)
                </div>
            </div>
        </div>
        
        <!-- Personal Details -->
        <div class="section-title">PERSONAL DETAILS</div>
        <table class="form-table">
            <tr>
                <td class="form-label">Student Name</td>
                <td class="form-field"></td>
                <td class="form-label">Father Name</td>
                <td class="form-field"></td>
            </tr>
            <tr>
                <td class="form-label">Gender</td>
                <td class="form-field">
                    <div class="checkbox-group">
                        <label>☐ Male</label>
                        <label>☐ Female</label>
                        <label>☐ Other</label>
                    </div>
                </td>
                <td class="form-label">Date of Birth</td>
                <td class="form-field"></td>
            </tr>
            <tr>
                <td class="form-label">CNIC / B-Form No</td>
                <td class="form-field"></td>
                <td class="form-label">Monthly Fees (Rs)</td>
                <td class="form-field"></td>
            </tr>
        </table>
        
        <!-- Contact Information -->
        <div class="section-title">CONTACT INFORMATION</div>
        <table class="form-table">
            <tr>
                <td class="form-label">Phone/Mobile</td>
                <td class="form-field"></td>
                <td class="form-label">Email</td>
                <td class="form-field"></td>
            </tr>
            <tr>
                <td class="form-label">Address</td>
                <td class="form-field address-field" colspan="3"></td>
            </tr>
        </table>
        
        <!-- Declaration -->
        <div class="section-title">DECLARATION</div>
        <table class="form-table">
            <tr>
                <td colspan="4">
                    <p class="declaration">
                        I hereby declare that the information provided above is true and correct to the best of my knowledge. I understand that any false information may result in cancellation of admission.
                    </p>
                    <div style="text-align: right; margin-top: 10px;">
                        _________________________<br>
                        <strong>Parent/Guardian Signature</strong>
                    </div>
                </td>
            </tr>
        </table>
        
        <!-- Office Use Only -->
        <div class="section-title">FOR OFFICE USE ONLY</div>
        <table class="form-table">
            <tr>
                <td class="form-label">Admission Approved</td>
                <td class="form-field">
                    <div class="checkbox-group">
                        <label>☐ Yes</label>
                        <label>☐ No</label>
                    </div>
                </td>
                <td class="form-label">Date</td>
                <td class="form-field"></td>
            </tr>
            <tr>
                <td class="form-label">Remarks</td>
                <td class="form-field remarks-field" colspan="3"></td>
            </tr>
        </table>
        
        <!-- Signatures -->
        <table class="signature-table">
            <tr>
                <td>
                    <div class="signature-line">
                        Parent/Guardian Signature
                    </div>
                </td>
                <td>
                    <div class="signature-line">
                        Principal Signature
                    </div>
                </td>
            </tr>
        </table>
        
        <!-- NAYA: Software Developer Text - CENTER MEIN -->
        <div class="developer-text">
            Software Developed by Liva Sol - www.livasol.com
        </div>
    </div>
    
    <script>
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>
<?php
    exit; 
}
// =========================================================
//            END: Print Mode Rendering
// =========================================================
?>

<div class="container-fluid">
    <h1 class="mt-4">Manual Admission Form <i class="fas fa-file-alt"></i></h1>
    
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <i class="fas fa-print"></i> Print Admission Form
        </div>
        <div class="card-body">
            <div class="alert alert-info">
                <strong>Instructions:</strong> 
                <ul>
                    <li>Yeh form manually fill karne ke liye hai</li>
                    <li>Print button dabayein aur form print kar lein</li>
                    <li>School staff ya parents is form ko fill kar sakte hain</li>
                    <li>Bharne ke baad form ko school office mein submit karein</li>
                </ul>
            </div>
            
            <div class="text-center">
                <a href="manual_admission_form.php?mode=print" target="_blank" class="btn btn-success btn-lg">
                    <i class="fas fa-print"></i> Print Admission Form
                </a>
                <a href="students.php" class="btn btn-secondary btn-lg">
                    <i class="fas fa-list"></i> Back to Student List
                </a>
            </div>
            
            <hr>
            
            <h5>Form Includes Following Fields:</h5>
            <div class="row">
                <div class="col-md-6">
                    <ul>
                        <li><strong>Admission Information:</strong></li>
                        <li>Registration No</li>
                        <li>Admission Date</li>
                        <li>Academic Session</li>
                        <li>Admission Class</li>
                        <li>Section</li>
                        <li>Roll Number</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <ul>
                        <li><strong>Personal Details:</strong></li>
                        <li>Student Name</li>
                        <li>Father Name</li>
                        <li>Gender</li>
                        <li>Date of Birth</li>
                        <li>CNIC/B-Form No</li>
                        <li>Monthly Fees</li>
                    </ul>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <ul>
                        <li><strong>Contact Information:</strong></li>
                        <li>Phone/Mobile</li>
                        <li>Email</li>
                        <li>Address</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <ul>
                        <li><strong>Office Use:</strong></li>
                        <li>Admission Approval</li>
                        <li>Remarks</li>
                        <li>Signatures</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php 
ob_end_flush(); 
include_once('includes/footer.php'); 
?>