<?php
// admin/print_monthly_attendance.php - FINAL FIXED CODE with Perfect Alignment and Phone Number

session_start();
// Assuming config/db.php exists and defines getDBConnection()
include_once('../config/db.php'); 

// --- Settings and Connection Setup ---
$conn = getDBConnection();
$settings_data = [];
$result = $conn->query("SELECT setting_key, setting_value FROM settings");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $settings_data[$row['setting_key']] = $row['setting_value'];
    }
    // Result ko free karna behtar practice hai
    $result->free(); 
}
$settings = array_merge($settings ?? [], $settings_data);


// Check for Print Mode
$is_print_mode = isset($_GET['mode']) && $_GET['mode'] === 'print';

if (!$is_print_mode) {
    // Assuming includes/header.php exists
    include_once('includes/header.php'); 
    
    // header.php mein connection close hone ke baad,
    // hum $conn ko dobara open kar rahe hain taaki neeche ki queries chal saken.
    $conn = getDBConnection(); 
}

// --- Current Session Fetch ---
$current_session_id = $settings['academic.active_session_id'] ?? 1;

// Fetch current session name
$session_query = "SELECT id, name FROM academic_sessions WHERE id = ?";
$session_stmt = $conn->prepare($session_query);
$session_stmt->bind_param("i", $current_session_id);
$session_stmt->execute();
$current_session = $session_stmt->get_result()->fetch_assoc();
$session_stmt->close();

// --- School/Report Details (Dynamic Fetching from settings table) ---
$school_name = $settings['institute.name'] ?? "Institute Name Not Set"; 
$school_address = $settings['institute.address'] ?? "Address Not Set"; 

// 🆕 FIX: Phone Number Fetch karna
$school_phone = $settings['institute.phone'] ?? "Phone Not Set"; 

$report_heading = "MONTHLY ATTENDANCE REPORT"; 

// --- Logo Path from Settings ---
$logo_db_path = $settings['institute.logo_path'] ?? ''; 
$logo_display_url = !empty($logo_db_path) ? '../' . $logo_db_path : '../assets/img/logo.png'; 


// --- Data Fetching Setup ---
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

// Classes aur Sections fetch karein
$classes_result = $conn->query("SELECT id, name FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);
$classes_result->free();

$sections_result = $conn->query("SELECT id, name FROM academic_sections WHERE status='active' ORDER BY name ASC");
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);
$sections_result->free();

$class_map = array_column($classes, 'name', 'id');
$section_map = array_column($sections, 'name', 'id');

$selected_class_id = $_GET['class_id'] ?? null;
$selected_section_id = $_GET['section_id'] ?? null;
$selected_month_year = $_GET['month_year'] ?? date('Y-m'); 

$students = [];
$attendance_data = [];
$attendance_summary = [];
$working_days_in_month = 0;
$report_title_data = '';

// --- Month Calculation ---
$start_date = date('Y-m-01', strtotime($selected_month_year));
$end_date = date('Y-m-t', strtotime($selected_month_year));
$num_days_in_month = date('t', strtotime($selected_month_year));

$month_dates = [];
for ($i = 1; $i <= $num_days_in_month; $i++) {
    $date_string = $selected_month_year . '-' . str_pad($i, 2, '0', STR_PAD_LEFT);
    $month_dates[$i] = $date_string;
}


// --- Load Students and Attendance Data ---
if ($selected_class_id && $selected_section_id) {
    $class_id = (int)$selected_class_id;
    $section_id = (int)$selected_section_id;

    $report_title_data = "Session: **{$current_session['name']}** | Class: **{$class_map[$class_id]}** | Section: **{$section_map[$section_id]}** | Month: **" . date('F Y', strtotime($selected_month_year)) . "**";

    // 1. Fetch Students
    $students_query = "
        SELECT s.id AS student_id, s.first_name, s.last_name, en.roll_no
        FROM students s
        JOIN student_enrollments en ON s.id = en.student_id
        WHERE en.session_id = {$current_session_id} 
          AND en.class_id = {$class_id} 
          AND en.section_id = {$section_id}
          AND s.status = 'active'
        ORDER BY en.roll_no ASC
    ";
    $students_result = $conn->query($students_query);
    if ($students_result) {
        $students = $students_result->fetch_all(MYSQLI_ASSOC);
        $students_result->free(); // Free the result set
    } 

    if (!empty($students)) {
        // 2. Fetch relevant Attendance Sheets
        $sheets_query = $conn->prepare("
            SELECT id, attendance_date 
            FROM daily_attendance_sheets 
            WHERE class_id = ? AND section_id = ? AND attendance_date BETWEEN ? AND ?
        ");
        $sheets_query->bind_param("iiss", $class_id, $section_id, $start_date, $end_date);
        $sheets_query->execute();
        $sheets_result = $sheets_query->get_result();
        $sheet_ids = [];
        $date_to_sheet_id = [];
        while($sheet = $sheets_result->fetch_assoc()){
            $sheet_ids[] = $sheet['id'];
            $date_to_sheet_id[$sheet['attendance_date']] = $sheet['id'];
        }
        $sheets_result->free(); // Free the result set
        $sheets_query->close();

        $working_days_in_month = count($sheet_ids);
        
        // 3. Fetch existing Attendance Records
        if (!empty($sheet_ids)) {
            $sheet_id_list = implode(',', $sheet_ids);
            $records_result = $conn->query("
                SELECT dar.student_id, dar.status, das.attendance_date 
                FROM daily_attendance_records dar
                JOIN daily_attendance_sheets das ON dar.sheet_id = das.id
                WHERE dar.sheet_id IN ({$sheet_id_list})
            ");

            foreach ($students as $student) {
                // Initialize summary counts for P, A, L, T (Total working days)
                $attendance_summary[$student['student_id']] = ['Present' => 0, 'Absent' => 0, 'Leave' => 0, 'Total' => 0];
            }

            while ($record = $records_result->fetch_assoc()) {
                $student_id = $record['student_id'];
                $day_of_month = (int)date('d', strtotime($record['attendance_date']));

                $status_char = $record['status'][0]; 
                $attendance_data[$student_id][$day_of_month] = $status_char; 

                $status = $record['status'];
                // Only count P, A, L 
                if (isset($attendance_summary[$student_id][$status])) {
                     $attendance_summary[$student_id][$status]++;
                }
                
                // Total Count (Working Days)
                if(isset($attendance_summary[$student_id]['Total'])){
                    $attendance_summary[$student_id]['Total']++;
                } else {
                    $attendance_summary[$student_id]['Total'] = 1;
                }

            }
            $records_result->free(); // Free the result set
        }
    }
}


// ** Report Table Content Function **
function generate_attendance_table($students, $num_days_in_month, $month_dates, $attendance_data, $date_to_sheet_id, $attendance_summary) {
    ob_start();
    ?>
    <div class="table-responsive">
        <table class="table table-bordered table-striped table-sm" style="width: 100%; margin: 0;">
            <thead class="thead-dark">
                <tr>
                    <th rowspan="2" style="width: 25px;">#</th>
                    <th rowspan="2" class="student-name">Student Name</th>
                    <th colspan="<?php echo $num_days_in_month; ?>">Daily Status (Day of Month)</th>
                    <th colspan="4" class="summary-col">Monthly Summary</th>
                </tr>
                <tr>
                    <?php for ($i = 1; $i <= $num_days_in_month; $i++): ?>
                        <th class="day-header"><?php echo $i; ?></th>
                    <?php endfor; ?>
                    <th class="summary-col">P</th>
                    <th class="summary-col">A</th>
                    <th class="summary-col">L</th>
                    <th class="summary-col">T</th> </tr>
            </thead>
            <tbody>
                <?php $row_num = 1; ?>
                <?php foreach ($students as $student): ?>
                    <?php 
                        $student_id = $student['student_id'];
                        $summary = $attendance_summary[$student_id] ?? ['Present' => 0, 'Absent' => 0, 'Leave' => 0, 'Total' => 0];
                        $present_count = $summary['Present'] ?? 0;
                        $absent_count = $summary['Absent'] ?? 0;
                        $leave_count = $summary['Leave'] ?? 0;
                        $total_count = $present_count + $absent_count + $leave_count; // P + A + L = Total Days Recorded
                    ?>
                <tr>
                    <td><?php echo $row_num++; ?></td>
                    <td class="student-name">
                        <?php echo htmlspecialchars($student['first_name'] . ' ' . $student['last_name']); ?> (R:<?php echo $student['roll_no']; ?>)
                    </td>
                    
                    <?php for ($i = 1; $i <= $num_days_in_month; $i++): ?>
                        <?php
                            $status_char = $attendance_data[$student_id][$i] ?? '';
                            $date_str = $month_dates[$i];
                            $is_working_day = isset($date_to_sheet_id[$date_str]); 
                            $display_status = $status_char ?: ($is_working_day ? '-' : ''); 
                        ?>
                        <td class="day-header status-<?php echo $status_char; ?>">
                            <?php echo $display_status; ?>
                        </td>
                    <?php endfor; ?>
                    
                    <td class="summary-col"><?php echo $present_count; ?></td>
                    <td class="summary-col"><?php echo $absent_count; ?></td>
                    <td class="summary-col"><?php echo $leave_count; ?></td>
                    <td class="summary-col total-col"><?php echo $total_count; ?></td> 
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php
    return ob_get_clean();
}

// =========================================================
//            START: Print Mode Rendering
// =========================================================

if ($is_print_mode) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Print Report - <?php echo date('F Y', strtotime($selected_month_year)); ?></title>
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css"> 
    <style>
        /* === FINAL CSS FIX FOR PRINT FIT & HEADER STYLES === */
        @media print {
            @page {
                size: landscape; 
                margin: 0.3cm; /* Page margin 0.3cm rakhi hai */
            }
            body, .report-container {
                padding: 0; 
                margin: 0; 
                width: 100%;
                font-size: 8pt; 
            }
            thead { display: table-header-group; }
            table { page-break-inside: auto; }
            tr { page-break-inside: avoid; page-break-after: auto; }
        }
        .report-container { 
            /* Page ki puri width use karein, sirf 5px left/right padding rakhi */
            padding: 0 5px; 
            width: 100%;
            box-sizing: border-box; /* Padding width mein shamil ho */
        }
        
        /* Header Styles - Width 100% of container (aligns with table) */
        .print-header { 
            max-width: 100%; /* Header line width 100% kar di */
            margin: 0 auto 5px auto; 
            padding: 5px 0; /* Padding adjust ki */
            border-bottom: 1px solid #333; 
            text-align: center; 
            overflow: hidden; 
        }
        /* Logo: Float Left - Size increased */
        .print-header .logo-container {
            float: left; 
            margin-right: 15px; 
        }
        .print-header img { 
            height: 70px; /* Logo height */
            width: auto;
        }
        /* School Info: Center mein rahega */
        .print-header .info-container {
            display: inline-block; 
            text-align: center; 
        }

        .print-header h3 { 
            margin: 0; 
            font-size: 14pt; 
            font-weight: bold; 
        }
        .print-header .address-line { 
            margin: 0; 
            font-size: 8pt; 
            line-height: 1.1; 
        }
        
        .report-info {
            text-align: center; font-size: 9pt; font-weight: bold;
            margin-top: 5px; margin-bottom: 5px;
        }
        
        /* Table Styles - Full Width (100% of container) */
        table { 
            width: 100%; /* Table width ko 100% kar diya */
            margin: 0; 
            border-collapse: collapse; 
            margin-top: 5px; 
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 3px 0px; 
            text-align: center; 
            font-size: 7pt; 
            line-height: 1.2; 
            white-space: nowrap; 
        }
        th { background-color: #f2f2f2; font-weight: bold; }
        
        /* Column Widths - Adjustments */
        td:first-child, th:first-child { 
             width: 25px; 
             min-width: 25px;
        }
        .day-header { 
            width: 20px; 
            min-width: 20px;
        } 
        .summary-col { 
            width: 18px !important; 
            min-width: 18px !important;
        }
        .total-col {
            background-color: #d1ecf1 !important; 
            font-weight: bold !important;
        }
        .student-name { 
            text-align: left; 
            padding-left: 3px !important; 
            width: 120px; 
        }
        /* Status Color Coding */
        .status-P { background-color: #d4edda; } 
        .status-A { background-color: #f8d7da; } 
        .status-L { background-color: #ffeeba; } 
        .summary-col { background-color: #e9ecef; font-weight: bold; }
    </style>
</head>
<body>
    <div class="report-container">
        <div class="print-header">
            <div class="logo-container">
                <img src="<?php echo htmlspecialchars($logo_display_url); ?>" alt="School Logo" onerror="this.style.display='none'">
            </div>

            <div class="info-container">
                <h3><?php echo htmlspecialchars($school_name); ?></h3>
                
                <p class="address-line"><?php echo htmlspecialchars($school_address); ?></p>
                
                <p class="address-line">Phone: <?php echo htmlspecialchars($school_phone); ?></p>
                
                <h4 style="margin-top: 5px; font-size: 12pt;"><?php echo $report_heading; ?></h4>
            </div>
            
            <div style="clear: both;"></div> 
        </div>
        <div class="report-info">
            <?php echo str_replace(['**', '|'], ['', '&nbsp; &nbsp;'], $report_title_data); ?> (Total Working Days: <?php echo $working_days_in_month; ?>)
        </div>
        
        <?php if (!empty($students)): ?>
            <?php echo generate_attendance_table($students, $num_days_in_month, $month_dates, $attendance_data, $date_to_sheet_id, $attendance_summary); ?>
        <?php else: ?>
            <div style="text-align: center; color: red; margin-top: 50px; font-size: 10pt;">
                No attendance data found for the selected criteria.
            </div>
        <?php endif; ?>

        <div style="margin-top: 10px; border-top: 1px solid #ddd; padding-top: 5px; font-size: 8pt; text-align: right;">
            **Note:** P=Present, A=Absent, L=Leave. T=Total Days Recorded.
        </div>
        
        <div style="margin-top: 40px; text-align: center; font-size: 9pt; width: 100%; margin: 40px 0 0 0;">
            <table style="width: 100%; margin: 0; border: none; border-collapse: separate;">
                <tr style="border: none;">
                    <td style="width: 33%; border: none; padding: 0; text-align: center;">
                        <div style="border-top: 1px solid #000; margin-top: 10px; padding-top: 2px; display: inline-block; width: 80%;">
                            Class Teacher Signature
                        </div>
                    </td>
                    <td style="width: 34%; border: none; padding: 0;">
                        &nbsp;
                    </td>
                    <td style="width: 33%; border: none; padding: 0; text-align: center;">
                        <div style="border-top: 1px solid #000; margin-top: 10px; padding-top: 2px; display: inline-block; width: 80%;">
                            Principal Signature
                        </div>
                    </td>
                </tr>
            </table>
        </div>
        </div>
    <script>
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>
<?php
    exit; 
}

// =========================================================
//            START: Screen Display Mode Rendering
// =========================================================
?>

<h1 class="mb-4">Monthly Attendance Report <i class="fas fa-file-alt"></i></h1>

<div class="card p-3 mb-4 shadow-sm">
    <h5 class="card-title">Select Session, Class, Section & Month</h5>
    <form method="GET" action="print_monthly_attendance.php" class="form-inline">
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Session:</label>
            <?php if ($current_session): ?>
                <input type="hidden" name="session_id" value="<?php echo $current_session['id']; ?>">
                <select class="form-control" disabled>
                    <option value="<?php echo $current_session['id']; ?>" selected>
                        <?php echo htmlspecialchars($current_session['name']); ?> (Current Session)
                    </option>
                </select>
            <?php else: ?>
                <select name="session_id" class="form-control" required>
                    <option value="">-- Select Session --</option>
                    <?php foreach ($sessions as $session): ?>
                        <option value="<?php echo $session['id']; ?>" <?php echo $current_session_id == $session['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($session['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <div class="alert alert-warning mt-2">No active session found. Please select a session manually.</div>
            <?php endif; ?>
        </div>
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Class:</label>
            <select name="class_id" class="form-control" required>
                <option value="">-- Select Class --</option>
                <?php foreach ($classes as $class): ?>
                    <option value="<?php echo $class['id']; ?>" <?php echo $selected_class_id == $class['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($class['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Section:</label>
            <select name="section_id" class="form-control" required>
                <option value="">-- Select Section --</option>
                <?php foreach ($sections as $section): ?>
                    <option value="<?php echo $section['id']; ?>" <?php echo $selected_section_id == $section['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($section['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group mr-3 mb-2">
            <label class="mr-2">Month:</label>
            <input type="month" name="month_year" class="form-control" value="<?php echo htmlspecialchars($selected_month_year); ?>" required>
        </div>
        <button type="submit" class="btn btn-info mb-2"><i class="fas fa-file-alt"></i> Generate Report</button>
        <?php if ($selected_class_id && $selected_section_id && count($students) > 0): ?>
             <?php 
                $print_url = "print_monthly_attendance.php?mode=print&class_id={$selected_class_id}&section_id={$selected_section_id}&month_year={$selected_month_year}";
             ?>
             <a href="<?php echo $print_url; ?>" target="_blank" class="btn btn-primary mb-2 ml-2"><i class="fas fa-print"></i> Print Report</a>
        <?php endif; ?>
    </form>
</div>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<?php if ($selected_class_id && $selected_section_id): ?>
    <?php if (count($students) > 0): ?>
        
        <h4 style="text-align: center; margin-bottom: 15px;">
            <?php echo str_replace(['**', '|'], ['', '&nbsp; &nbsp;'], $report_title_data); ?> (Total Working Days: <?php echo $working_days_in_month; ?>)
        </h4>
        
        <?php echo generate_attendance_table($students, $num_days_in_month, $month_dates, $attendance_data, $date_to_sheet_id, $attendance_summary); ?>

        <div style="margin-top: 20px; font-size: 9pt;">
            **Note:** P=Present, A=Absent, L=Leave. T=Total Days Recorded.
        </div>

    <?php else: ?>
        <div class="alert alert-warning">Is Class/Section mein koi active student **enroll** nahi mila for the current session.</div>
    <?php endif; ?>
<?php else: ?>
    <div class="alert alert-info">Barah-e-meherbani class, section aur month select karein.</div>
<?php endif; ?>

<?php
if (!$is_print_mode) {
    // Assuming includes/footer.php exists
    include_once('includes/footer.php'); 
}
?>