<?php
// FILE: admin/print_session_class_view.php - Logic to Fetch Data for ALL Students in a Class/Section

session_start();
ob_start();
include_once('../config/db.php');

$conn = getDBConnection();

// --- START: Settings Fetch Logic --- 
$settings_data = [];
$settings_query = $conn->query("SELECT setting_key, setting_value FROM settings");
if ($settings_query) {
    while ($row = $settings_query->fetch_assoc()) {
        $settings_data[trim($row['setting_key'])] = trim($row['setting_value']);
    }
}
$settings['institute_name'] = $settings_data['institute.name'] ?? $settings_data['institute name'] ?? $settings_data['institute_name'] ?? "SCHOOL NAME (UPDATE SETTINGS)";
$settings['institute_address'] = $settings_data['institute.address'] ?? $settings_data['institute address'] ?? $settings_data['institute_address'] ?? "Address Not Set";
$settings['institute_phone'] = $settings_data['institute.phone'] ?? $settings_data['institute phone'] ?? $settings_data['institute_phone'] ?? ""; 
$current_session_id = $settings_data['academic.active_session_id'] ?? 1;
$rawLogoPath = $settings_data['institute.logo_path'] ?? $settings_data['institute logo path'] ?? '';
$logoPathParts = explode('|', $rawLogoPath);
$cleanLogoPath = trim($logoPathParts[0]);
$settings['logo_url'] = !empty($cleanLogoPath) ? '../' . $cleanLogoPath : null;
// --- END: Settings Fetch Logic ---

$selected_class_id = $_GET['class_id'] ?? null;
$selected_section_id = $_GET['section_id'] ?? null;

$students_to_print = [];
$exam_terms = [];

if ($selected_class_id) {
    $class_id = (int)$selected_class_id;
    $section_id = $selected_section_id ? (int)$selected_section_id : NULL;

    // 1. Fetch ALL Students in Class/Section
    $query = "
        SELECT 
            s.id, s.first_name, s.last_name, s.father_name, 
            en.roll_no, 
            ac.name as class_name, 
            asec.name as section_name
        FROM students s
        JOIN student_enrollments en ON s.id = en.student_id
        JOIN academic_classes ac ON en.class_id = ac.id
        LEFT JOIN academic_sections asec ON en.section_id = asec.id
        WHERE en.session_id = ? AND en.class_id = ? AND s.status = 'active'
    ";
    $params = [$current_session_id, $class_id];
    $types = "ii";

    if ($section_id !== NULL) {
        $query .= " AND en.section_id = ?";
        $params[] = $section_id;
        $types .= "i";
    }
    
    $query .= " ORDER BY en.roll_no ASC";
    
    $stmt = $conn->prepare($query);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $students_to_print = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    // 2. Fetch all Exam IDs and Names for the Current Session
    $exams_query = $conn->prepare("
        SELECT id, name FROM exams 
        WHERE session_id = ? 
        ORDER BY id ASC
    ");
    $exams_query->bind_param("i", $current_session_id);
    $exams_query->execute();
    $exam_terms = $exams_query->get_result()->fetch_all(MYSQLI_ASSOC);
    $exams_query->close();
}

// Main Print Loop
if (count($students_to_print) > 0) {
    echo '<style>@media print { .no-print { display: none !important; } }</style>';
    
    // ✅ PAGE BREAK FIX: Har student ka result naye page par shuru hoga.
    echo '<style>
    @media print {
        .student-result-card {
            page-break-after: always;
            break-after: page; 
        }
        /* Aakhri card ke baad page break na ho */
        .student-result-card:last-child {
            page-break-after: auto;
            break-after: auto;
        }
        @page {
            /* Margins kam karne se content zyada fit ho jayega */
            margin: 0.25in; 
        }
    }
    </style>';
    
    echo '<button onclick="window.print()" class="btn btn-warning no-print" style="position:fixed; top:10px; right:10px; z-index:1000;"><i class="fas fa-print"></i> Print All</button>';
    
    // Loop through each student to generate result card
    foreach ($students_to_print as $student_data) {
        $student_id = (int)$student_data['id'];
        $all_terms_results = [];

        // 3. Loop through each exam (Term) to fetch marks for the current student
        foreach ($exam_terms as $exam_term) {
            $exam_id = (int)$exam_term['id'];
            $term_name = htmlspecialchars($exam_term['name']);

            // Fetch Subject Structure and Marks data
            $marks_query = "
                SELECT 
                    acs.id AS subject_id, acs.name AS subject_name,
                    ces.total_marks, ces.passing_marks,
                    em.marks_obtained, em.is_absent
                FROM subjects acs 
                INNER JOIN course_allocation ca ON ca.subject_id = acs.id 
                LEFT JOIN class_exam_structure ces ON ces.subject_id = acs.id AND ces.exam_id = ? AND ces.class_id = ?
                LEFT JOIN exam_marks em 
                    ON em.subject_id = acs.id 
                    AND em.student_id = ? 
                    AND em.exam_id = ?
                    AND em.class_id = ?
                WHERE ca.class_id = ? 
                ORDER BY acs.name ASC
            ";
            
            $marks_stmt = $conn->prepare($marks_query);
            $marks_stmt->bind_param("iiiiii", $exam_id, $class_id, $student_id, $exam_id, $class_id, $class_id);
            $marks_stmt->execute();
            $marks_data = $marks_stmt->get_result()->fetch_all(MYSQLI_ASSOC);
            $marks_stmt->close();
            
            $all_terms_results[] = [
                'term_id' => $exam_id,
                'term_name' => $term_name,
                'marks_data' => $marks_data
            ];
        }
        
        // Render the template for the current student
        $print_data = [
            'settings' => $settings,
            'student_data' => $student_data,
            'all_terms_results' => $all_terms_results
        ];
        extract($print_data);
        
        // Agar aapne print_session_result_template.php ko theek kar liya hai (Phase 1),
        // to yeh include ab theek chalega.
        include('print_session_result_template.php'); 
    }
} else {
    echo "<div class='error-page'><h1>No Students Found</h1><p>No active students found in the selected class/section for the current session.</p></div>";
}

if (isset($conn) && is_object($conn)) {
    $conn->close();
}
ob_end_flush();
?>