<?php
// FILE: admin/print_session_individual_view.php - Logic to Fetch Data for ONE Student's Session Result

session_start();
ob_start();
include_once('../config/db.php');

$conn = getDBConnection();

// --- START: Settings Fetch Logic --- 
$settings_data = [];
$settings_query = $conn->query("SELECT setting_key, setting_value FROM settings");
if ($settings_query) {
    while ($row = $settings_query->fetch_assoc()) {
        $settings_data[trim($row['setting_key'])] = trim($row['setting_value']);
    }
}
$settings['institute_name'] = $settings_data['institute.name'] ?? $settings_data['institute name'] ?? $settings_data['institute_name'] ?? "SCHOOL NAME (UPDATE SETTINGS)";
$settings['institute_address'] = $settings_data['institute.address'] ?? $settings_data['institute address'] ?? $settings_data['institute_address'] ?? "Address Not Set";
$settings['institute_phone'] = $settings_data['institute.phone'] ?? $settings_data['institute phone'] ?? $settings_data['institute_phone'] ?? ""; 
$current_session_id = $settings_data['academic.active_session_id'] ?? 1;
$rawLogoPath = $settings_data['institute.logo_path'] ?? $settings_data['institute logo path'] ?? '';
$logoPathParts = explode('|', $rawLogoPath);
$cleanLogoPath = trim($logoPathParts[0]);
$settings['logo_url'] = !empty($cleanLogoPath) ? '../' . $cleanLogoPath : null;
// --- END: Settings Fetch Logic ---


// ✅ Page Break CSS Added
echo '<style>
    @media print {
        /* Single Student Card ko naye page se print kare aur ek page par adjust kare */
        .student-result-card {
            page-break-before: always;
            break-before: page;
        }
        @page {
             /* Margins kam karne se content zyada fit ho jayega */
            margin: 0.25in; 
        }
    }
    </style>';


$selected_class_id = $_GET['class_id'] ?? null;
$selected_student_id = $_GET['student_id'] ?? null;

$student_data = null;
$all_terms_results = [];
$exam_terms = [];

if ($selected_class_id && $selected_student_id) {
    $class_id = (int)$selected_class_id;
    $student_id = (int)$selected_student_id;

    // 1. Fetch Student Details
    $student_query = "
        SELECT 
            s.id, s.first_name, s.last_name, s.father_name, s.phone, s.dob, s.address, s.gender,
            en.roll_no, 
            ac.name as class_name, 
            asec.name as section_name
        FROM students s
        JOIN student_enrollments en ON s.id = en.student_id
        JOIN academic_classes ac ON en.class_id = ac.id
        LEFT JOIN academic_sections asec ON en.section_id = asec.id
        WHERE en.session_id = ? AND en.class_id = ? AND s.id = ? AND s.status = 'active'
    ";
    $student_stmt = $conn->prepare($student_query);
    $student_stmt->bind_param("iii", $current_session_id, $class_id, $student_id);
    $student_stmt->execute();
    $student_data = $student_stmt->get_result()->fetch_assoc();
    $student_stmt->close();
    
    // 2. Fetch all Exam IDs and Names for the Current Session
    if ($student_data) {
        $exams_query = $conn->prepare("
            SELECT id, name FROM exams 
            WHERE session_id = ? 
            ORDER BY id ASC
        ");
        $exams_query->bind_param("i", $current_session_id);
        $exams_query->execute();
        $exam_terms = $exams_query->get_result()->fetch_all(MYSQLI_ASSOC);
        $exams_query->close();

        // 3. Loop through each exam (Term) to fetch marks for the current student
        foreach ($exam_terms as $exam_term) {
            $exam_id = (int)$exam_term['id'];
            $term_name = htmlspecialchars($exam_term['name']);

            // Fetch Subject Structure and Marks data
            $marks_query = "
                SELECT 
                    acs.id AS subject_id, acs.name AS subject_name,
                    ces.total_marks, ces.passing_marks,
                    em.marks_obtained, em.is_absent
                FROM subjects acs 
                INNER JOIN course_allocation ca ON ca.subject_id = acs.id 
                LEFT JOIN class_exam_structure ces ON ces.subject_id = acs.id AND ces.exam_id = ? AND ces.class_id = ?
                LEFT JOIN exam_marks em 
                    ON em.subject_id = acs.id 
                    AND em.student_id = ? 
                    AND em.exam_id = ?
                    AND em.class_id = ?
                WHERE ca.class_id = ? 
                ORDER BY acs.name ASC
            ";
            
            $marks_stmt = $conn->prepare($marks_query);
            $marks_stmt->bind_param("iiiiii", $exam_id, $class_id, $student_id, $exam_id, $class_id, $class_id);
            $marks_stmt->execute();
            $marks_data = $marks_stmt->get_result()->fetch_all(MYSQLI_ASSOC);
            $marks_stmt->close();
            
            $all_terms_results[] = [
                'term_id' => $exam_id,
                'term_name' => $term_name,
                'marks_data' => $marks_data
            ];
        }
    }
}

// Display Logic
if ($student_data && count($all_terms_results) > 0) {
    // Pass the fetched data to the print template
    $print_data = [
        'settings' => $settings,
        'student_data' => $student_data,
        'all_terms_results' => $all_terms_results
    ];
    extract($print_data);
    
    // Ensure the result is wrapped in <div class="student-result-card">...</div> 
    // inside the template file for the page break to work correctly.
    include_once('print_session_result_template.php'); 
} else {
    echo "
        <style>
            .error-page { font-family: Arial, sans-serif; text-align: center; padding-top: 50px; }
            .error-page h1 { color: #d9534f; }
        </style>
        <div class='error-page'>
            <h1>Data Not Found</h1>
            <p>Could not find active student data or exam results for the selected criteria.</p>
        </div>
    ";
}

if (isset($conn) && is_object($conn)) {
    $conn->close();
}
ob_end_flush();
?>