<?php
// FILE: admin/salary_slips_bulk_print.php
include_once('../config/db.php');
$conn = getDBConnection();

$month_year = $_GET['month'] ?? '';

if (empty($month_year)) {
    die("Error: Month not specified for bulk print.");
}

// 1. Fetch ALL Salary Slip IDs for the selected Month
$slips_query = "
    SELECT tss.id
    FROM teacher_salary_slips tss
    JOIN teachers t ON tss.teacher_id = t.id
    WHERE DATE_FORMAT(tss.month_year, '%Y-%m') = ? 
    ORDER BY t.name ASC
";
$stmt = $conn->prepare($slips_query);
$stmt->bind_param("s", $month_year);
$stmt->execute();
$slips_result = $stmt->get_result();
$slip_ids = $slips_result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
$conn->close();

if (empty($slip_ids)) {
    die("No salary slips found for " . date('F Y', strtotime($month_year)));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Bulk Salary Slips Print - <?php echo date('F Y', strtotime($month_year)); ?></title>
    <style>
        body { font-family: Arial, sans-serif; margin: 0; padding: 0; font-size: 10pt; }
        .slip-page-break {
            width: 800px; 
            margin: 20px auto; 
            /* Hide print button if it's included in salary_slip_print.php */
            .btn-primary[onclick="window.print()"] { display: none; }
        }
        /* Page break after each slip for clean printout */
        @media print {
            .slip-page-break {
                page-break-after: always;
                border: none;
                margin: 0;
            }
            .slip-page-break:last-child {
                page-break-after: avoid; /* Stop page break after the last slip */
            }
        }
    </style>
</head>
<body onload="window.print()">
    
    <?php
    // Loop through each slip ID and include the content from the single print file
    foreach ($slip_ids as $slip) {
        $slip_id = $slip['id'];
        
        echo '<div class="slip-page-break">';
        // Temporarily set the ID for the included file
        $_GET['id'] = $slip_id;
        
        // Include the content of your single slip print file here
        // Note: salary_slip_print.php should not contain <html>, <head>, or <body> tags
        include 'salary_slip_print.php'; 
        echo '</div>';
    }
    ?>
</body>
</html>