<?php
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

$conn = getDBConnection();
$message = $_GET['msg'] ?? '';
$error = $_GET['err'] ?? '';

// 💥 FIX: Settings ko database se load karein (Agar header.php mein load nahi ho raha)
$settings = [];
$settings_query = $conn->query("SELECT setting_key, setting_value FROM settings");
while ($row = $settings_query->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
if (!isset($settings['academic.active_session_id'])) {
    $settings['academic.active_session_id'] = 1; 
}


// --- Data Fetching ---

// 1. Fetch Classes Data
$classes_result = $conn->query("SELECT * FROM academic_classes ORDER BY order_no ASC");
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);

// 2. Fetch Sections Data
$sections_result = $conn->query("SELECT * FROM academic_sections ORDER BY name ASC");
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);

// 3. Fetch Class-Section Combinations (Assignments)
$assigned_result = $conn->query("
    SELECT 
        cs.id as assignment_id, ac.name as class_name, s.name as section_name, 
        cs.capacity, aes.name as session_name, ac.id as class_id, s.id as section_id
    FROM class_sections cs
    JOIN academic_classes ac ON cs.class_id = ac.id
    JOIN academic_sections s ON cs.section_id = s.id
    JOIN academic_sessions aes ON cs.session_id = aes.id
    WHERE cs.session_id = {$settings['academic.active_session_id']}
    ORDER BY ac.order_no, s.name
");
$assignments = $assigned_result->fetch_all(MYSQLI_ASSOC);

$conn->close();
?>

<h1 class="mb-4">Classes and Sections Management</h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<ul class="nav nav-tabs" id="myTab" role="tablist">
    <li class="nav-item">
        <a class="nav-link active" id="class-tab" data-toggle="tab" href="#classes" role="tab">1. Manage Classes</a>
    </li>
    <li class="nav-item">
        <a class="nav-link" id="section-tab" data-toggle="tab" href="#sections" role="tab">2. Manage Sections</a>
    </li>
    <li class="nav-item">
        <a class="nav-link" id="assign-tab" data-toggle="tab" href="#assign" role="tab">3. Assign Sections to Classes</a>
    </li>
</ul>

<div class="tab-content mt-3">
    
    <div class="tab-pane fade show active" id="classes" role="tabpanel">
        <div class="row">
            <div class="col-md-5">
                <h4>Add New Class</h4>
                <form action="classes_process.php" method="POST">
                    <input type="hidden" name="action" value="add_class">
                    <div class="form-group">
                        <label>Class Name (e.g., Nursery, 5th, Matric):</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Display Order (Kam number pehle show hoga):</label>
                        <input type="number" name="order_no" class="form-control" value="0" disabled>
                    </div>
                    <button type="submit" class="btn btn-primary">Save Class</button>
                </form>
            </div>
            <div class="col-md-7">
                <h4>Existing Classes (<?php echo count($classes); ?>)</h4>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <!-- <th>Code</th> -->
                            <th>Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($classes as $class): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($class['name']); ?></td>
                            <!-- <td><?php echo htmlspecialchars($class['code'] ?? 'N/A'); ?></td> -->
                            <td><?php echo htmlspecialchars($class['order_no']); ?></td>
                            <td>
                                <a href="edit_class.php?id=<?php echo $class['id']; ?>" class="btn btn-sm btn-info">Edit</a>
                                
                                <a href="classes_process.php?action=delete_class&id=<?php echo $class['id']; ?>" 
                                    class="btn btn-sm btn-danger" 
                                    onclick="return confirm('WARNING: Is Class ko delete karne se related enrollment data masla kar sakta hai. Kya aap yaqeen rakhte hain?');">
                                    Delete
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <div class="tab-pane fade" id="sections" role="tabpanel">
        <div class="row">
            <div class="col-md-5">
                <h4>Add New Section</h4>
                <form action="classes_process.php" method="POST">
                    <input type="hidden" name="action" value="add_section">
                    <div class="form-group">
                        <label>Section Name (e.g., A, B, Green, Morning):</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Save Section</button>
                </form>
            </div>
            <div class="col-md-7">
                <h4>Existing Sections (<?php echo count($sections); ?>)</h4>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr><th>Name</th><th>Actions</th></tr>
                    </thead>
                    <tbody>
                        <?php foreach ($sections as $section): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($section['name']); ?></td>
                            <td>
                                <a href="edit_section.php?id=<?php echo $section['id']; ?>" class="btn btn-sm btn-info">Edit</a>

                                <a href="classes_process.php?action=delete_section&id=<?php echo $section['id']; ?>" 
                                    class="btn btn-sm btn-danger" 
                                    onclick="return confirm('WARNING: Is Section ko delete karne se pehle iske assigned classes se remove karna lazim hai. Delete karein?');">
                                    Delete
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <div class="tab-pane fade" id="assign" role="tabpanel">
        <div class="row">
            <div class="col-md-5">
                <h4>Assign Section</h4>
                <form action="classes_process.php" method="POST">
                    <input type="hidden" name="action" value="assign_section">
                    <input type="hidden" name="session_id" value="<?php echo $settings['academic.active_session_id']; ?>">
                    <div class="form-group">
                        <label>Select Class:</label>
                        <select name="class_id" class="form-control" required>
                            <option value="">-- Select --</option>
                            <?php foreach ($classes as $class): ?>
                                <option value="<?php echo $class['id']; ?>"><?php echo htmlspecialchars($class['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Select Section:</label>
                        <select name="section_id" class="form-control" required>
                            <option value="">-- Select --</option>
                            <?php foreach ($sections as $section): ?>
                                <option value="<?php echo $section['id']; ?>"><?php echo htmlspecialchars($section['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Capacity (Max Students):</label>
                        <input type="number" name="capacity" class="form-control" value="40" required>
                    </div>
                    <button type="submit" class="btn btn-success">Assign Class-Section</button>
                </form>
            </div>
            <div class="col-md-7">
                <h4>Current Class Assignments (Session: <?php echo $settings['academic.active_session_id']; ?>)</h4>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr><th>Class</th><th>Section</th><th>Capacity</th><th>Actions</th></tr>
                    </thead>
                    <tbody>
                        <?php foreach ($assignments as $assign): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($assign['class_name']); ?></td>
                            <td><?php echo htmlspecialchars($assign['section_name']); ?></td>
                            <td><?php echo htmlspecialchars($assign['capacity']); ?></td>
                            <td><a href="classes_process.php?action=delete_assignment&id=<?php echo $assign['assignment_id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?');">Remove</a></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
include_once('includes/footer.php'); 
?>