<?php
// admin/settings.php - FIXED VERSION (Logo Always Displays Correctly + Phone Number Field)
include_once('includes/header.php');
$conn = getDBConnection();

// Authorization check
if (!isset($user_role_id) || $user_role_id != 1) {
    $redirect_page = isset($_SESSION['user_id']) ? 'dashboard.php' : '../index.php';
    header('Location: ' . $redirect_page . '?err=' . urlencode('Access denied or session expired.'));
    exit;
}

$message = '';
$error = '';

// === Handle Form Submission ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['action'] === 'update_settings') {
    $institute_name = trim($_POST['institute_name']);
    $institute_address = trim($_POST['institute_address']);
    // New: Phone number field fetch
    $institute_phone = trim($_POST['institute_phone']); 

    if (empty($institute_name)) {
        $error = "School name is required.";
    } else {
        $logo_path = null;
        if (isset($_FILES['logo_file']) && $_FILES['logo_file']['error'] === UPLOAD_ERR_OK) {
            $file_tmp = $_FILES['logo_file']['tmp_name'];
            $file_name = basename($_FILES['logo_file']['name']);
            $file_size = $_FILES['logo_file']['size'];
            $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

            $allowed = ['jpg', 'jpeg', 'png'];
            if (!in_array($file_ext, $allowed)) {
                $error = "Only JPG or PNG images allowed.";
            } elseif ($file_size > 500 * 1024) {
                $error = "Logo size must be under 500KB.";
            } else {
                $upload_dir = '../uploads/';
                if (!file_exists($upload_dir)) mkdir($upload_dir, 0777, true);
                $new_filename = 'school_logo_' . time() . '.' . $file_ext;
                $target_path = $upload_dir . $new_filename;

                if (move_uploaded_file($file_tmp, $target_path)) {
                    // Save path relative to project root
                    $logo_path = 'uploads/' . $new_filename;
                } else {
                    $error = "Failed to upload logo.";
                }
            }
        }

        if (empty($error)) {
            $settings = [
                'institute.name' => $institute_name,
                'institute.address' => $institute_address,
                'institute.phone' => $institute_phone // New: Phone number added
            ];
            if ($logo_path) {
                $settings['institute.logo_path'] = $logo_path;
            }

            foreach ($settings as $key => $value) {
                $stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value, group_name)
                                         VALUES (?, ?, 'institute')
                                         ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
                $stmt->bind_param('ss', $key, $value);
                $stmt->execute();
                $stmt->close();
            }

            $message = "Settings updated successfully!";
        }
    }
}

// === Fetch Settings from Database ===
$settings_data = [];
$result = $conn->query("SELECT setting_key, setting_value FROM settings");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $settings_data[$row['setting_key']] = $row['setting_value'];
    }
}

$current_logo_path = $settings_data['institute.logo_path'] ?? '';
$logo_display_url = !empty($current_logo_path) ? '../' . $current_logo_path : '';

?>

<h1 class="mb-4">General System Settings ⚙️</h1>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="card p-4">
    <h4 class="card-title">School & Organization Details</h4>
    <form action="" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="update_settings">

        <div class="form-row">
            <div class="form-group col-md-8">
                <label>School Name:</label>
                <input type="text" name="institute_name" class="form-control"
                    value="<?php echo htmlspecialchars($settings_data['institute.name'] ?? ''); ?>" required>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-8">
                <label>School Address:</label>
                <textarea name="institute_address" class="form-control" rows="3"><?php echo htmlspecialchars($settings_data['institute.address'] ?? ''); ?></textarea>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group col-md-8">
                <label>Institute Phone:</label>
                <input type="text" name="institute_phone" class="form-control"
                    value="<?php echo htmlspecialchars($settings_data['institute.phone'] ?? ''); ?>">
            </div>
        </div>
        <h4 class="mt-4">School Logo 🖼️</h4>
        <div class="form-row align-items-start">
            <div class="form-group col-md-4">
                <label>Current Logo:</label><br>

                <?php 
                $logo_full_path = '../' . $current_logo_path;
                // Note: File existence check is added here for reliable logo display
                if (!empty($current_logo_path) && file_exists($logo_full_path)): ?>
                    <div style="margin-top:10px; border:1px solid #ccc; padding:5px; display:inline-block; background:#f9f9f9;">
                        <img src="<?php echo htmlspecialchars($logo_display_url); ?>" 
                            alt="School Logo" style="max-width:150px;">
                    </div>
                    <p class="text-success mt-2">✅ Logo uploaded successfully.</p>
                <?php else: ?>
                    <p class="text-danger mt-2">No logo uploaded yet.</p>
                <?php endif; ?>
            </div>

            <div class="form-group col-md-4">
                <label for="logo_file">Upload New Logo (JPG/PNG):</label>
                <input type="file" name="logo_file" id="logo_file" class="form-control-file">
                <small class="form-text text-muted">Only upload if you want to change the current logo. Max 500 KB.</small>
            </div>
        </div>

        <h4 class="mt-4">Academic Settings</h4>
        <div class="form-row">
            <div class="form-group col-md-8">
                <label>Active Academic Session ID:</label>
                <input type="text" class="form-control" disabled 
                    value="<?php echo htmlspecialchars($settings_data['academic.active_session_id'] ?? 'N/A'); ?>">
                <small class="form-text text-muted">Change directly from settings table if needed.</small>
            </div>
        </div>

        <button type="submit" class="btn btn-success mt-3"><i class="fas fa-save"></i> Save Settings</button>
    </form>
</div>

<?php include_once('includes/footer.php'); ?>