<?php
// student_leaving_confirm.php

include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

// DB Connection: Yeh file (db.php) admin se bahar hai, isliye '../config/db.php' sahi hai.
include_once('../config/db.php'); 

// --- Functions ---
// Note: getDBConnection() function yahan se hata diya gaya hai.
// Ab woh direct ../config/db.php se call hoga.

function redirectWithError($message) {
    header('Location: student_leaving.php?err=' . urlencode($message));
    exit;
}

// --- Main Logic ---
$conn = getDBConnection(); // Function ab ../config/db.php se call hoga
if (!$conn) {
    redirectWithError('Database connection failed!');
}

$student_id = (int)($_GET['student_id'] ?? 0);
$student_name = htmlspecialchars($_GET['name'] ?? 'N/A');
$student_rollno = htmlspecialchars($_GET['roll'] ?? 'N/A');

if ($student_id <= 0) {
    redirectWithError('Invalid student ID provided.');
}

// --- FEES CHECK LOGIC ---

$pending_vouchers = [];
$fees_cleared = true;

try {
    $check_fees_query = "
        SELECT 
            voucher_no, month_year, net_payable
        FROM fee_invoices 
        WHERE student_id = ? 
          AND (status = 'unpaid' OR status = 'partial') 
          AND due_date <= CURDATE() 
    ";
    
    $stmt = $conn->prepare($check_fees_query);
    
    if (!$stmt) {
        throw new Exception('DB Prepare Error: ' . $conn->error);
    }
    
    $stmt->bind_param("i", $student_id);
    if (!$stmt->execute()) {
        throw new Exception('DB Execute Error: ' . $stmt->error);
    }
    
    $result = $stmt->get_result();
    $pending_vouchers = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    if (count($pending_vouchers) > 0) {
        $fees_cleared = false;
    }
    
} catch (Exception $e) {
    redirectWithError('A serious error occurred while checking fees: ' . $e->getMessage());
}

$conn->close();
?>

<h1 class="mb-4">School Leaving Confirmation</h1>

<div class="card">
    <div class="card-header">
        Processing Withdrawal for: **<?php echo $student_name; ?>** (Roll No: <?php echo $student_rollno; ?>)
    </div>
    <div class="card-body">
        
        <?php if (!$fees_cleared): ?>
            <div class="alert alert-danger">
                🛑 **FEES PENDING!** Is student ki pending fees hai.
                <p>Fees clear kiye baghair School Leave process nahi ho sakta.</p>
            </div>
            
            <p><strong>Pending Fees Details:</strong></p>
            <ul>
                <?php foreach ($pending_vouchers as $voucher): ?>
                    <li>Voucher No: **<?php echo htmlspecialchars($voucher['voucher_no']); ?>** (Month: <?php echo htmlspecialchars($voucher['month_year']); ?>) - Payable: **<?php echo htmlspecialchars($voucher['net_payable']); ?> PKR**</li>
                <?php endforeach; ?>
            </ul>
            
            <a href="student_leaving.php" class="btn btn-secondary mt-3">Go Back</a>
            
        <?php else: ?>
            <div class="alert alert-success">
                ✅ **FEES CLEAR!** Is student ki koi fees pending nahi hai. Aap aage badh sakte hain.
            </div>
            
            <form action="student_leaving_process.php" method="POST">
                <input type="hidden" name="action" value="leave_student">
                <input type="hidden" name="student_id" value="<?php echo $student_id; ?>">
                <input type="hidden" name="fees_cleared" value="1">
                
                <div class="form-group mt-3">
                    <label for="leaving_reason">Reason for Leaving: <span class="text-danger">*</span></label>
                    <textarea class="form-control" name="reason" id="leaving_reason" required rows="3"></textarea>
                </div>
                
                <p class="text-danger mt-4">Irade se **Confirm School Leave** button dabayein. Yeh student ko system se **withdrawn** mark kar dega.</p>
                
                <a href="student_leaving.php" class="btn btn-secondary">Cancel / Go Back</a>
                <button type="submit" class="btn btn-danger">Confirm School Leave</button>
            </form>
            
        <?php endif; ?>
        
    </div>
</div>

<?php include_once('includes/footer.php'); ?>