<?php
// Start of PHP
include_once('includes/header.php'); 
include_once('includes/sidebar.php'); 

// Extra: Hidden/invisible characters removed from code provided by user
$conn = getDBConnection();
$message = $_GET['msg'] ?? $_GET['err'] ?? ''; // msg for success, err for danger/error
$view = $_GET['view'] ?? 'list'; // Default view list hoga
$is_error = isset($_GET['err']);
$teacher_to_edit = null;

// 1. Fetch Teacher List
$teachers_result = $conn->query("SELECT * FROM teachers WHERE status='active' ORDER BY name ASC");
$teachers = $teachers_result->fetch_all(MYSQLI_ASSOC);

// 2. Fetch Teacher Data for Editing (If view is 'edit')
if ($view === 'edit' && isset($_GET['id']) && is_numeric($_GET['id'])) {
    $teacher_id = (int)$_GET['id'];
    // Prepared statement for security
    $stmt = $conn->prepare("SELECT * FROM teachers WHERE id = ?");
    $stmt->bind_param("i", $teacher_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $teacher_to_edit = $result->fetch_assoc();
    $stmt->close();

    // Agar teacher nahi mila to list view par redirect kar dein
    if (!$teacher_to_edit) {
        $view = 'list'; // Fallback to list view
        $message = 'Error: Teacher not found.';
        $is_error = true;
    }
}

$conn->close();
// End of PHP
?>

<h1 class="mb-4">Teachers / Staff Management</h1>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $is_error ? 'danger' : 'success'; ?>"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($view !== 'edit'): // Hide tabs when showing the edit form ?>
<ul class="nav nav-tabs" id="teachersTab" role="tablist">
    <li class="nav-item">
        <a class="nav-link <?php echo $view === 'list' ? 'active' : ''; ?>" href="teachers.php?view=list">Teachers List</a>
    </li>
    <li class="nav-item">
        <a class="nav-link <?php echo $view === 'add' ? 'active' : ''; ?>" href="teachers.php?view=add">Add New Teacher</a>
    </li>
</ul>
<?php endif; ?>

<div class="tab-content mt-3">
    
    <?php if ($view === 'edit' && $teacher_to_edit): 
        // ====================================================================
        // EDIT TEACHER FORM VIEW
        // ====================================================================
        // Jab view edit ho to sirf yeh form dikhao
    ?>
    <div class="card card-body">
        <h4>Edit Teacher: <?php echo htmlspecialchars($teacher_to_edit['name']); ?></h4>
        <form action="teachers_process.php" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="action" value="edit_teacher">
            <input type="hidden" name="teacher_id" value="<?php echo $teacher_to_edit['id']; ?>">

            <div class="row">
                <div class="form-group col-md-12 text-right">
                    <img src="../uploads/teachers/<?php echo htmlspecialchars($teacher_to_edit['photo'] ?? 'default.png'); ?>" alt="Photo" style="width: 100px; height: 100px; object-fit: cover; border: 1px solid #ddd;">
                </div>
            </div>

            <h5>Personal & Employment Details</h5>
            <div class="row">
                <div class="form-group col-md-4"><label>Name:</label><input type="text" name="name" class="form-control" value="<?php echo htmlspecialchars($teacher_to_edit['name']); ?>" required></div>
                <div class="form-group col-md-4"><label>Employee No (Optional):</label><input type="text" name="emp_no" class="form-control" value="<?php echo htmlspecialchars($teacher_to_edit['emp_no'] ?? ''); ?>"></div>
                <div class="form-group col-md-4"><label>Designation:</label><input type="text" name="designation" class="form-control" value="<?php echo htmlspecialchars($teacher_to_edit['designation']); ?>" required></div>
                <div class="form-group col-md-4"><label>Qualification:</label><input type="text" name="qualification" class="form-control" value="<?php echo htmlspecialchars($teacher_to_edit['qualification'] ?? ''); ?>"></div>
                <div class="form-group col-md-4"><label>CNIC (Unique):</label><input type="text" name="cnic" class="form-control" value="<?php echo htmlspecialchars($teacher_to_edit['cnic']); ?>" required></div>
                <div class="form-group col-md-4"><label>Phone:</label><input type="text" name="phone" class="form-control" value="<?php echo htmlspecialchars($teacher_to_edit['phone']); ?>" required></div>
                <div class="form-group col-md-4"><label>Joining Date:</label><input type="date" name="joining_date" class="form-control" value="<?php echo htmlspecialchars($teacher_to_edit['joining_date']); ?>" required></div>
                
                <div class="form-group col-md-4"><label>Monthly Salary (PKR):</label><input type="number" name="salary" step="1" class="form-control" value="<?php echo htmlspecialchars($teacher_to_edit['salary'] ?? ''); ?>" required></div>
                
                <div class="form-group col-md-4"><label>Change Photo (Optional):</label><input type="file" name="photo" class="form-control-file"></div>
                <div class="form-group col-md-4">
                    <label>Status:</label>
                    <select name="status" class="form-control" required>
                        <option value="active" <?php echo $teacher_to_edit['status'] === 'active' ? 'selected' : ''; ?>>Active</option>
                        <option value="inactive" <?php echo $teacher_to_edit['status'] === 'inactive' ? 'selected' : ''; ?>>Inactive/Withdrawn</option>
                    </select>
                </div>
            </div>
            
            <button type="submit" class="btn btn-warning btn-lg mt-4">Update Teacher Details</button>
            <a href="teachers.php?view=list" class="btn btn-secondary btn-lg mt-4">Cancel / Back to List</a>
            <button type="button" class="btn btn-danger btn-lg mt-4" onclick="confirmDelete(<?php echo $teacher_to_edit['id']; ?>)">Delete Teacher</button>
        </form>
    </div>

    <?php else: // Display List or Add tabs ?>

    <div class="tab-pane fade <?php echo $view === 'list' ? 'show active' : ''; ?>" id="list" role="tabpanel">
        <h4 class="mb-3">Active Teachers (<?php echo count($teachers); ?>)</h4>
        <table class="table table-bordered table-striped table-sm">
            <thead>
                <tr>
                    <th>Emp No</th>
                    <th>Name</th>
                    <th>Designation</th>
                    <th>Qualification</th>
                    <th>Phone</th>
                    <th>Joining Date</th>
                    <th>Salary</th> 
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($teachers as $teacher): ?>
                <tr>
                    <td><?php echo htmlspecialchars($teacher['emp_no'] ?? '-'); ?></td>
                    <td><?php echo htmlspecialchars($teacher['name']); ?></td>
                    <td><?php echo htmlspecialchars($teacher['designation'] ?? '-'); ?></td>
                    <td><?php echo htmlspecialchars($teacher['qualification'] ?? '-'); ?></td>
                    <td><?php echo htmlspecialchars($teacher['phone'] ?? '-'); ?></td>
                    <td><?php echo htmlspecialchars($teacher['joining_date']); ?></td>
                    <td><?php echo 'Rs. ' . number_format($teacher['salary'] ?? 0); ?></td>
                    <td>
                        <a href="teachers.php?view=edit&id=<?php echo $teacher['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                        <button onclick="confirmDelete(<?php echo $teacher['id']; ?>)" class="btn btn-sm btn-danger">Delete</button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <div class="tab-pane fade <?php echo $view === 'add' ? 'show active' : ''; ?>" id="add" role="tabpanel">
        <h4>Add New Teacher / Staff</h4>
        <form action="teachers_process.php" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="action" value="add_teacher">

            <h5>Personal & Employment Details</h5>
            <div class="row">
                <div class="form-group col-md-4"><label>Name:</label><input type="text" name="name" class="form-control" required></div>
                <div class="form-group col-md-4"><label>Employee No (Optional):</label><input type="text" name="emp_no" class="form-control"></div>
                <div class="form-group col-md-4"><label>Designation:</label><input type="text" name="designation" class="form-control" required></div>
                <div class="form-group col-md-4"><label>Qualification:</label><input type="text" name="qualification" class="form-control"></div>
                <div class="form-group col-md-4"><label>CNIC (Unique):</label><input type="text" name="cnic" class="form-control" required></div>
                <div class="form-group col-md-4"><label>Phone:</label><input type="text" name="phone" class="form-control" required></div>
                <div class="form-group col-md-4"><label>Joining Date:</label><input type="date" name="joining_date" class="form-control" value="<?php echo date('Y-m-d'); ?>" required></div>
                
                <div class="form-group col-md-4"><label>Monthly Salary (PKR):</label><input type="number" name="salary" step="1" class="form-control" required></div>
                
                <div class="form-group col-md-4"><label>Photo:</label><input type="file" name="photo" class="form-control-file"></div>
            </div>
            
            <button type="submit" class="btn btn-success btn-lg mt-4">Save Teacher</button>
        </form>
    </div>

    <?php endif; ?>

</div>

<script>
function confirmDelete(teacherId) {
    if (confirm('Are you sure you want to delete this teacher? This action cannot be undone.')) {
        window.location.href = 'teachers_process.php?action=delete_teacher&id=' + teacherId;
    }
}
</script>

<?php
include_once('includes/footer.php'); 
?>