<?php
// install/index.php - Single-Step Installation Form (Final Version)

// Check if installation is already done (config file exists)
// Agar config file maujood hai to user ko reinstall nahi karne dega.
if (file_exists('../config/db.php')) {
    echo "<!DOCTYPE html><html><head><title>Installation Complete</title></head><body>";
    echo "<h1>Installation Already Done!</h1>";
    echo "<p>The config file (config/db.php) already exists. To reinstall, please delete config/db.php and all tables from your database first.</p>";
    echo "<p><a href='../admin/login.php'>Go to Admin Login</a></p>";
    echo "</body></html>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Installation</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 20px; }
        .container { max-width: 700px; margin: 50px auto; background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1); }
        h2 { text-align: center; color: #333; margin-bottom: 30px; }
        .form-section { border: 1px solid #ccc; padding: 20px; margin-bottom: 20px; border-radius: 6px; }
        .form-section h4 { color: #007bff; margin-top: 0; border-bottom: 1px solid #eee; padding-bottom: 10px; margin-bottom: 15px; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; color: #555; }
        .form-group input { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        #message { margin-top: 20px; padding: 15px; border-radius: 4px; text-align: center; font-weight: bold; display: none; }
        .msg-success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .msg-error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .btn-install { width: 100%; padding: 12px; background-color: #28a745; border: none; color: white; border-radius: 4px; cursor: pointer; font-size: 18px; margin-top: 20px; }
        .btn-install:hover:not(:disabled) { background-color: #218838; }
        .btn-install:disabled { background-color: #6c757d; cursor: not-allowed; }
    </style>
</head>
<body>

<div class="container">
    <h2>School Management System Installation</h2>
    <div id="message" style="display: none;"></div>

    <form id="installForm" action="process.php" method="POST">
        
        <div class="form-section">
            <h4>1. Database Setup (MySQL/MariaDB)</h4>
            <p>Aapka database <span style="font-weight: bold;">pehle se bana hua</span> hona zaroori hai.</p>
            <div class="form-group">
                <label for="servername">DB Host:</label>
                <input type="text" id="servername" name="servername" value="localhost" required>
            </div>
            <div class="form-group">
                <label for="username">DB User:</label>
                <input type="text" id="username" name="username" value="root" required>
            </div>
            <div class="form-group">
                <label for="password">DB Password (Khali chor dain agar zaroori na ho):</label>
                <input type="password" id="password" name="password" value="" autocomplete="new-password">
            </div>
            <div class="form-group">
                <label for="dbname">Database Name (Jo aapne abhi banaya hai):</label>
                <input type="text" id="dbname" name="dbname" required>
            </div>
        </div>

        <div class="form-section">
            <h4>2. Administrator Account Setup</h4>
            <div class="form-group">
                <label for="admin_username">Admin Username:</label>
                <input type="text" id="admin_username" name="admin_username" value="admin" required>
            </div>
            <div class="form-group">
                <label for="admin_password">Admin Password (Minimum 6 characters):</label>
                <input type="password" id="admin_password" name="admin_password" required autocomplete="new-password">
            </div>
        </div>
        
        <div class="form-section">
            <h4>3. Institute Information</h4>
            <div class="form-group">
                <label for="institute_name">Institute Name:</label>
                <input type="text" id="institute_name" name="institute_name" required>
            </div>
            <div class="form-group">
                <label for="institute_address">Institute Address:</label>
                <input type="text" id="institute_address" name="institute_address" required>
            </div>
            </div>

        <button type="submit" class="btn-install" id="installBtn">Start Installation</button>
    </form>
</div>

<script>
document.getElementById('installForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const form = e.target;
    const formData = new FormData(form);
    const messageDiv = document.getElementById('message');
    const installBtn = document.getElementById('installBtn');
    
    // Reset message area and disable button
    messageDiv.style.display = 'none';
    messageDiv.className = '';
    installBtn.disabled = true;
    installBtn.textContent = 'Installing... Please wait.';

    fetch('process.php', {
        method: 'POST',
        body: formData
    })
    .then(response => {
        // Handle non-JSON responses (if PHP error occurs)
        if (!response.ok) {
            return response.text().then(text => {
                // If a critical PHP error happens, we display the error message in the console.
                console.error("Server Response Error:", text); 
                throw new Error(`Server Error (${response.status}). Please check your process.php file.`);
            });
        }
        return response.json();
    })
    .then(data => {
        if (data.status === 'complete') {
            messageDiv.className = 'msg-success';
            messageDiv.innerHTML = data.message + `<br>Redirecting to login...`;
            messageDiv.style.display = 'block';
            
            // Redirect to admin login page
            setTimeout(() => {
                window.location.href = data.admin_url;
            }, 3000); 

        } else {
            // Installation failed, show error message
            messageDiv.className = 'msg-error';
            messageDiv.textContent = 'Installation Failed: ' + data.message;
            messageDiv.style.display = 'block';
            installBtn.disabled = false;
            installBtn.textContent = 'Start Installation';
        }
    })
    .catch(error => {
        // Critical network or JavaScript error
        console.error('Fetch Error:', error);
        messageDiv.className = 'msg-error';
        messageDiv.textContent = 'Critical Error: ' + error.message;
        messageDiv.style.display = 'block';
        installBtn.disabled = false;
        installBtn.textContent = 'Start Installation';
    });
});
</script>

</body>
</html>