 <?php
// install/step1_db.php

// Agar already installed.flag file mojood hai, to redirect kar dein.
if (file_exists(__DIR__ . '/../storage/installed.flag')) {
    header('Location: ../index.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Step 1: Database Setup</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .container { max-width: 600px; margin-top: 50px; }
    </style>
</head>
<body>
    <div class="container">
        <h2 class="text-center mb-4">🏫 LMS Installer - Step 1/2</h2>
        <h4 class="text-center mb-4">Database Configuration</h4>
        <form action="process.php" method="POST">
            <input type="hidden" name="step" value="db_config">
            
            <div class="form-group">
                <label for="db_host">Database Host:</label>
                <input type="text" class="form-control" id="db_host" name="db_host" value="localhost" required>
                <small class="form-text text-muted">Aksar 'localhost' hota hai.</small>
            </div>
            
            <div class="form-group">
                <label for="db_name">Database Name:</label>
                <input type="text" class="form-control" id="db_name" name="db_name" placeholder="fees_db_01" required>
            </div>
            
            <div class="form-group">
                <label for="db_user">Database Username:</label>
                <input type="text" class="form-control" id="db_user" name="db_user" required>
            </div>
            
            <div class="form-group">
                <label for="db_pass">Database Password:</label>
                <input type="password" class="form-control" id="db_pass" name="db_pass">
            </div>
            
            <button type="submit" class="btn btn-primary btn-block mt-4">Next: Run Setup & Admin Info</button>
            
            <?php if(isset($_GET['error'])): ?>
                <div class="alert alert-danger mt-3">
                    <strong>Error:</strong> <?php echo htmlspecialchars($_GET['error']); ?>
                </div>
            <?php endif; ?>

        </form>
    </div>
</body>
</html>