<?php
// FILE: parent/includes/header.php

// Note: Session aur Authorization check har page ke top par hoga (jaise dashboard.php mein kiya tha)
// Example: session_start();
//          if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 2) { ... }

// Assuming necessary utility files are included in the main page (like ../config/db.php)

// Session variables ko fetch karein
$parent_name = htmlspecialchars($_SESSION['name'] ?? 'Parent');
$parent_user_id = (int)($_SESSION['user_id'] ?? 0);

// --- Settings/Institute Name Fetch (Optional, agar har page mein connection open na ho toh isse main file mein karna behtar hai) ---
// Note: Agar aapko school ka naam header mein dikhana hai, toh aapko yahan database connection open karna hoga, ya isse main page se pass karna hoga.
// Filhaal, hum hardcode ya session/default value istemal kar rahe hain.
$institute_name = "LMS Parent Portal"; 
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="Parent Portal for LMS" />
    <meta name="author" content="Your School Name" />
    <title>Parent Dashboard - <?php echo $institute_name; ?></title>
    
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet" />
    
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet" />
    
    <style>
        body {
            background-color: #f8f9fa;
        }
        .navbar {
            background-color: #3f51b5; /* Primary Color for Parent Portal */
        }
        .navbar-brand, .navbar-nav .nav-link {
            color: #ffffff !important;
        }
        .navbar-nav .nav-link:hover {
            color: #ffeb3b !important;
        }
        .main-content {
            padding-top: 20px;
            padding-bottom: 50px;
        }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark shadow-sm">
    <div class="container">
        <a class="navbar-brand" href="dashboard.php">
            <i class="fas fa-user-graduate"></i> <?php echo $institute_name; ?>
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav mr-auto">
                <li class="nav-item">
                    <a class="nav-link" href="dashboard.php"><i class="fas fa-home"></i> Home</a>
                </li>
                </ul>
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <span class="nav-link text-warning"><i class="fas fa-user-circle"></i> Welcome, <?php echo $parent_name; ?></span>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="./logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<div class="main-content container-fluid">