 <?php
// portal/dashboard.php
session_start();
include_once('../config/db.php');

// Security Check: Portal User logged in?
if (!isset($_SESSION['is_portal_user']) || !$_SESSION['is_portal_user']) {
    header('Location: login.php');
    exit;
}

$student_id = $_SESSION['student_id'];
$student_name = $_SESSION['student_name'];
$roll_no = $_SESSION['roll_no'];
$conn = getDBConnection();

// --- Data Fetching ---
$current_session_id = $settings['academic.active_session_id'] ?? 0; // Assuming settings loaded
$class_id = 0;

// Fetch Student's current Class ID
$enrollment_res = $conn->query("SELECT class_id FROM student_enrollments WHERE student_id = {$student_id} AND session_id = {$current_session_id}");
if ($enrollment_res->num_rows > 0) {
    $class_id = $enrollment_res->fetch_assoc()['class_id'];
}

// 1. Fetch Latest Exam Result Summary
$latest_result = [];
if ($class_id) {
    $result_query = $conn->query("
        SELECT sr.*, e.name AS exam_name 
        FROM student_results sr
        JOIN exams e ON sr.exam_id = e.id
        WHERE sr.student_id = {$student_id} 
        ORDER BY e.id DESC 
        LIMIT 1
    ");
    $latest_result = $result_query->fetch_assoc();
}

// 2. Fetch Latest Fee Invoice/Dues Summary
$fees_summary = [];
$fees_res = $conn->query("
    SELECT SUM(net_payable) AS total_payable, SUM(amount_paid) AS total_paid
    FROM fee_invoices 
    WHERE student_id = {$student_id} AND session_id = {$current_session_id}
");
$fees_summary = $fees_res->fetch_assoc();
$fees_due = ($fees_summary['total_payable'] ?? 0) - ($fees_summary['total_paid'] ?? 0);


$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Student Dashboard</title>
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <a class="navbar-brand" href="dashboard.php">Student Portal</a>
    <div class="collapse navbar-collapse">
        <ul class="navbar-nav mr-auto">
            <li class="nav-item active"><a class="nav-link" href="#">Home</a></li>
            <li class="nav-item"><a class="nav-link" href="result_card.php">My Result Card</a></li>
            <li class="nav-item"><a class="nav-link" href="fees_history.php">Fees & Payments</a></li>
        </ul>
        <ul class="navbar-nav ml-auto">
            <span class="navbar-text text-white mr-3">
                Welcome, **<?php echo htmlspecialchars($student_name); ?>** (Roll: <?php echo htmlspecialchars($roll_no); ?>)
            </span>
            <li class="nav-item">
                <a class="btn btn-danger btn-sm" href="logout.php">Logout</a>
            </li>
        </ul>
    </div>
</nav>

<div class="container mt-5">
    
    <div class="jumbotron">
        <h1 class="display-4">Welcome Back, <?php echo htmlspecialchars($student_name); ?>!</h1>
        <p class="lead">Yahan aap apni tamam academic aur financial history dekh sakte hain.</p>
    </div>

    <div class="row">
        
        <div class="col-md-6 mb-4">
            <div class="card text-white bg-info h-100">
                <div class="card-header">Latest Exam Result</div>
                <div class="card-body">
                    <?php if ($latest_result): ?>
                        <h5 class="card-title">**<?php echo htmlspecialchars($latest_result['exam_name']); ?>**</h5>
                        <p class="card-text">
                            **Percentage:** <?php echo number_format($latest_result['percentage'], 2); ?> %<br>
                            **Grade:** <?php echo htmlspecialchars($latest_result['grade']); ?><br>
                            **Status:** <span class="badge badge-<?php echo ($latest_result['result_status'] === 'Pass') ? 'success' : 'danger'; ?>"><?php echo htmlspecialchars($latest_result['result_status']); ?></span>
                        </p>
                        <a href="result_card.php" class="btn btn-light">View Full Result</a>
                    <?php else: ?>
                        <p class="card-text">Koi result abhi tak finalize nahi hua hai.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-md-6 mb-4">
            <div class="card text-white bg-warning h-100">
                <div class="card-header">Fees Summary (Current Session)</div>
                <div class="card-body">
                    <h5 class="card-title">**Total Payable:** Rs. <?php echo number_format($fees_summary['total_payable'] ?? 0); ?></h5>
                    <p class="card-text">
                        **Total Paid:** Rs. <?php echo number_format($fees_summary['total_paid'] ?? 0); ?><br>
                        **Remaining Due:** <span class="font-weight-bold text-danger">Rs. <?php echo number_format($fees_due); ?></span>
                    </p>
                    <a href="fees_history.php" class="btn btn-light">View Payment History</a>
                </div>
            </div>
        </div>
        
        </div>
</div>
<?php 
// Logout file (portal/logout.php) bhi banana hoga
// session_destroy(); header('Location: login.php');
?>
</body>
</html>