 <?php
// portal/result_card.php
session_start();
include_once('../config/db.php');

if (!isset($_SESSION['is_portal_user']) || !$_SESSION['is_portal_user']) {
    header('Location: login.php');
    exit;
}

$student_id = $_SESSION['student_id'];
$student_name = $_SESSION['student_name'];
$conn = getDBConnection();

$current_session_id = $settings['academic.active_session_id'] ?? 0;
$class_id = 0;
$result_details = [];
$exam_id_to_view = $_GET['exam_id'] ?? null;

// Fetch Student's current Class ID
$enrollment_res = $conn->query("SELECT class_id FROM student_enrollments WHERE student_id = {$student_id} AND session_id = {$current_session_id}");
if ($enrollment_res->num_rows > 0) {
    $class_id = $enrollment_res->fetch_assoc()['class_id'];
}

// Fetch Finalized Exams for dropdown (only exams student was enrolled for)
$exams_result = $conn->query("
    SELECT DISTINCT e.id, e.name 
    FROM student_results sr 
    JOIN exams e ON sr.exam_id = e.id
    WHERE sr.student_id = {$student_id} 
    ORDER BY e.id DESC
");
$exams = $exams_result->fetch_all(MYSQLI_ASSOC);

if ($exam_id_to_view && $class_id) {
    $exam_id = (int)$exam_id_to_view;

    // A. Fetch Result Summary
    $summary_res = $conn->query("
        SELECT sr.*, e.name AS exam_name
        FROM student_results sr
        JOIN exams e ON sr.exam_id = e.id
        WHERE sr.student_id = {$student_id} AND sr.exam_id = {$exam_id}
    ");
    $summary = $summary_res->fetch_assoc();

    // B. Fetch Subject-wise Marks and Structure
    $details_query = "
        SELECT 
            s.name AS subject_name,
            ces.total_marks,
            ces.passing_marks,
            em.marks_obtained
        FROM class_exam_structure ces
        JOIN subjects s ON ces.subject_id = s.id
        LEFT JOIN exam_marks em ON em.exam_id = ces.exam_id AND em.subject_id = ces.subject_id AND em.student_id = {$student_id}
        WHERE ces.exam_id = {$exam_id} AND ces.class_id = {$class_id}
        ORDER BY s.name ASC
    ";
    $details_result = $conn->query($details_query);
    $result_details = $details_result->fetch_all(MYSQLI_ASSOC);
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Result Card</title>
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <a class="navbar-brand" href="dashboard.php">Student Portal</a>
    <ul class="navbar-nav ml-auto">
        <li class="nav-item"><a class="btn btn-sm btn-danger" href="logout.php">Logout</a></li>
    </ul>
</nav>

<div class="container mt-5">
    <h1 class="mb-4">My Result Card</h1>

    <div class="card p-3 mb-4">
        <h5 class="card-title">Select Exam</h5>
        <form method="GET" action="result_card.php" class="form-inline">
            <div class="form-group mr-3">
                <label class="mr-2">Exam:</label>
                <select name="exam_id" class="form-control" onchange="this.form.submit()" required>
                    <option value="">-- Select Exam --</option>
                    <?php foreach ($exams as $exam): ?>
                        <option value="<?php echo $exam['id']; ?>" <?php echo $exam_id_to_view == $exam['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($exam['name']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <?php if (!$exam_id_to_view): ?><button type="submit" class="btn btn-info">View Result</button><?php endif; ?>
        </form>
    </div>

    <?php if ($exam_id_to_view && isset($summary)): ?>
        
        <div class="card p-4 mb-4" id="result-card-print">
            <h2 class="text-center text-info">**<?php echo htmlspecialchars($summary['exam_name']); ?>** Result</h2>
            <hr>
            <div class="row mb-3">
                <div class="col-md-6">**Name:** <?php echo htmlspecialchars($student_name); ?></div>
                <div class="col-md-6">**Roll No:** <?php echo htmlspecialchars($_SESSION['roll_no']); ?></div>
            </div>
            
            <h5 class="mt-3">Subject Wise Marks:</h5>
            <table class="table table-bordered table-sm">
                <thead class="bg-light">
                    <tr><th>Subject</th><th>Total Marks</th><th>Passing Marks</th><th>Marks Obtained</th><th>Status</th></tr>
                </thead>
                <tbody>
                    <?php $failed = false; foreach ($result_details as $detail): ?>
                    <?php 
                        $marks = $detail['marks_obtained'] ?? 0;
                        $pass = (float)$detail['passing_marks'];
                        $status = ($marks >= $pass) ? 'Pass' : 'Fail';
                        if ($status === 'Fail') $failed = true;
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($detail['subject_name']); ?></td>
                        <td><?php echo (int)$detail['total_marks']; ?></td>
                        <td><?php echo (int)$detail['passing_marks']; ?></td>
                        <td class="font-weight-bold <?php echo ($status === 'Fail') ? 'text-danger' : 'text-success'; ?>"><?php echo number_format($marks, 2); ?></td>
                        <td><?php echo $status; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <div class="row mt-4">
                <div class="col-md-6">
                    <p><strong>Total Max Marks:</strong> <?php echo number_format($summary['total_max_marks']); ?></p>
                    <p><strong>Total Marks Obtained:</strong> <?php echo number_format($summary['total_marks_obtained'], 2); ?></p>
                </div>
                <div class="col-md-6 text-right">
                    <h3 class="mt-0">**Percentage:** <?php echo number_format($summary['percentage'], 2); ?> %</h3>
                    <h2 class="mt-0">**Grade:** <?php echo htmlspecialchars($summary['grade']); ?></h2>
                    <h2 class="mt-0">**Result Status:** <span class="badge badge-lg badge-<?php echo ($summary['result_status'] === 'Pass') ? 'success' : 'danger'; ?>"><?php echo htmlspecialchars($summary['result_status']); ?></span></h2>
                </div>
            </div>
        </div>
        <button class="btn btn-secondary mb-5" onclick="window.print()">Print Result Card</button>
        
    <?php elseif ($exam_id_to_view): ?>
        <div class="alert alert-warning">Is Exam ($exam_name) ka result abhi tak finalize nahi hua hai.</div>
    <?php endif; ?>
</div>

</body>
</html>