-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Oct 26, 2025 at 11:08 AM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `ammo`
--

-- --------------------------------------------------------

--
-- Table structure for table `academic_classes`
--

CREATE TABLE `academic_classes` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `code` varchar(10) DEFAULT NULL,
  `order_no` int(11) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `academic_classes`
--

INSERT INTO `academic_classes` (`id`, `name`, `code`, `order_no`) VALUES
(1, 'Play Group', NULL, 0),
(2, 'Nursery', NULL, 0),
(3, 'Prep', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `academic_sections`
--

CREATE TABLE `academic_sections` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `status` enum('active','inactive') DEFAULT 'active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `academic_sections`
--

INSERT INTO `academic_sections` (`id`, `name`, `status`) VALUES
(1, 'A', 'active'),
(2, 'B', 'active'),
(3, 'C', 'active');

-- --------------------------------------------------------

--
-- Table structure for table `academic_sessions`
--

CREATE TABLE `academic_sessions` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `is_active` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `academic_sessions`
--

INSERT INTO `academic_sessions` (`id`, `name`, `start_date`, `end_date`, `is_active`) VALUES
(1, '2024-2025', '2024-08-01', '2025-07-31', 1),
(2, '2026-2027', '2026-01-01', '2027-12-31', 0);

-- --------------------------------------------------------

--
-- Table structure for table `class_exam_structure`
--

CREATE TABLE `class_exam_structure` (
  `id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `total_marks` int(4) NOT NULL,
  `passing_marks` int(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `class_exam_structure`
--

INSERT INTO `class_exam_structure` (`id`, `exam_id`, `class_id`, `subject_id`, `total_marks`, `passing_marks`) VALUES
(1, 1, 1, 9, 100, 33),
(2, 1, 1, 10, 100, 33),
(3, 1, 1, 7, 100, 33),
(4, 1, 1, 8, 100, 33),
(13, 1, 2, 11, 100, 33),
(14, 1, 2, 9, 100, 33),
(15, 1, 2, 10, 100, 33),
(16, 1, 2, 7, 100, 33),
(17, 1, 2, 8, 100, 33),
(18, 1, 3, 11, 100, 33),
(19, 1, 3, 9, 100, 33),
(20, 1, 3, 10, 100, 33),
(21, 1, 3, 7, 100, 33),
(22, 1, 3, 8, 100, 33);

-- --------------------------------------------------------

--
-- Table structure for table `class_sections`
--

CREATE TABLE `class_sections` (
  `id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `class_teacher_id` int(11) DEFAULT NULL,
  `capacity` int(11) DEFAULT 40
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `class_sections`
--

INSERT INTO `class_sections` (`id`, `session_id`, `class_id`, `section_id`, `class_teacher_id`, `capacity`) VALUES
(1, 1, 1, 1, NULL, 40),
(2, 1, 2, 1, NULL, 40),
(3, 1, 3, 1, NULL, 40);

-- --------------------------------------------------------

--
-- Table structure for table `course_allocation`
--

CREATE TABLE `course_allocation` (
  `id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) DEFAULT NULL,
  `subject_id` int(11) NOT NULL,
  `teacher_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `course_allocation`
--

INSERT INTO `course_allocation` (`id`, `session_id`, `class_id`, `section_id`, `subject_id`, `teacher_id`) VALUES
(5, 1, 1, 1, 9, 1),
(6, 1, 1, 1, 10, 1),
(7, 1, 1, 1, 7, 1),
(8, 1, 1, 1, 8, 1),
(9, 1, 3, NULL, 11, 1),
(10, 1, 3, NULL, 9, 1),
(11, 1, 3, NULL, 10, 1),
(12, 1, 3, NULL, 7, 1),
(13, 1, 3, NULL, 8, 1),
(14, 1, 2, NULL, 11, 1),
(15, 1, 2, NULL, 9, 1),
(16, 1, 2, NULL, 10, 1),
(17, 1, 2, NULL, 7, 1),
(18, 1, 2, NULL, 8, 1);

-- --------------------------------------------------------

--
-- Table structure for table `daily_attendance_records`
--

CREATE TABLE `daily_attendance_records` (
  `id` int(11) NOT NULL,
  `sheet_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `status` enum('Present','Absent','Leave','Late') NOT NULL,
  `note` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `daily_attendance_records`
--

INSERT INTO `daily_attendance_records` (`id`, `sheet_id`, `student_id`, `status`, `note`) VALUES
(8, 9, 12, 'Present', ''),
(9, 10, 13, 'Present', ''),
(10, 11, 14, 'Present', '');

-- --------------------------------------------------------

--
-- Table structure for table `daily_attendance_sheets`
--

CREATE TABLE `daily_attendance_sheets` (
  `id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `attendance_date` date NOT NULL,
  `recorded_by_teacher_id` int(11) DEFAULT NULL,
  `is_locked` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `daily_attendance_sheets`
--

INSERT INTO `daily_attendance_sheets` (`id`, `session_id`, `class_id`, `section_id`, `attendance_date`, `recorded_by_teacher_id`, `is_locked`, `created_at`) VALUES
(3, 0, 1, 1, '2025-10-22', 1, 0, '2025-10-22 10:21:48'),
(4, 0, 1, 1, '2025-10-24', 1, 0, '2025-10-24 06:50:42'),
(5, 0, 1, 1, '2025-10-01', 1, 0, '2025-10-24 12:20:03'),
(6, 0, 1, 1, '2025-10-14', 1, 0, '2025-10-24 12:20:10'),
(7, 0, 1, 1, '2025-10-23', 1, 0, '2025-10-24 12:20:17'),
(8, 0, 1, 1, '2025-10-25', 1, 0, '2025-10-25 08:42:29'),
(9, 0, 1, 1, '2025-10-26', 1, 0, '2025-10-26 08:19:30'),
(10, 0, 2, 1, '2025-10-26', 1, 0, '2025-10-26 08:19:34'),
(11, 0, 3, 1, '2025-10-26', 1, 0, '2025-10-26 08:19:38');

-- --------------------------------------------------------

--
-- Table structure for table `exams`
--

CREATE TABLE `exams` (
  `id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` enum('term','final') DEFAULT 'term',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` enum('active','completed') DEFAULT 'active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `exams`
--

INSERT INTO `exams` (`id`, `session_id`, `name`, `type`, `start_date`, `end_date`, `status`) VALUES
(1, 1, 'First Term Examination', 'term', '2025-10-22', '2026-10-22', 'active');

-- --------------------------------------------------------

--
-- Table structure for table `exam_marks`
--

CREATE TABLE `exam_marks` (
  `id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `marks_obtained` decimal(5,2) NOT NULL,
  `is_absent` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `exam_marks`
--

INSERT INTO `exam_marks` (`id`, `exam_id`, `student_id`, `class_id`, `subject_id`, `marks_obtained`, `is_absent`) VALUES
(56, 1, 12, 1, 9, 34.00, 0),
(57, 1, 12, 1, 10, 33.00, 0),
(58, 1, 12, 1, 7, 43.00, 0),
(59, 1, 12, 1, 8, 0.00, 1),
(60, 1, 13, 2, 11, 34.00, 0),
(61, 1, 13, 2, 9, 33.00, 0),
(62, 1, 13, 2, 10, 43.00, 0),
(63, 1, 13, 2, 7, 32.00, 0),
(64, 1, 13, 2, 8, 31.00, 0),
(65, 1, 14, 3, 11, 34.00, 0),
(66, 1, 14, 3, 9, 35.00, 0),
(67, 1, 14, 3, 10, 33.00, 0),
(68, 1, 14, 3, 7, 32.00, 0),
(69, 1, 14, 3, 8, 31.00, 0);

-- --------------------------------------------------------

--
-- Table structure for table `fee_heads`
--

CREATE TABLE `fee_heads` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` enum('fee','discount','fine') NOT NULL DEFAULT 'fee',
  `is_recurring` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `fee_heads`
--

INSERT INTO `fee_heads` (`id`, `name`, `type`, `is_recurring`) VALUES
(1, 'Tuition Fee', 'fee', 1),
(2, 'Admission Fee', 'fee', 0),
(3, 'Exam Fee', 'fee', 0),
(4, 'Transport Fee', '', 1),
(5, 'Scholarship/Concession', 'discount', 0),
(6, 'Late Payment Fine', 'fine', 0);

-- --------------------------------------------------------

--
-- Table structure for table `fee_invoices`
--

CREATE TABLE `fee_invoices` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `voucher_no` varchar(50) NOT NULL,
  `month_year` char(7) NOT NULL,
  `issue_date` date NOT NULL,
  `due_date` date DEFAULT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `net_payable` decimal(10,2) NOT NULL,
  `amount_paid` decimal(10,2) DEFAULT 0.00,
  `fine_charged` decimal(10,2) DEFAULT 0.00,
  `status` enum('unpaid','partial','paid','cancelled') DEFAULT 'unpaid'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `fee_invoices`
--

INSERT INTO `fee_invoices` (`id`, `student_id`, `session_id`, `voucher_no`, `month_year`, `issue_date`, `due_date`, `total_amount`, `net_payable`, `amount_paid`, `fine_charged`, `status`) VALUES
(22, 12, 1, 'VCHR-1022', '2025-10', '2025-10-26', '0000-00-00', 2000.00, 2000.00, 0.00, 0.00, 'unpaid'),
(23, 13, 1, 'VCHR-1023', '2025-10', '2025-10-26', '0000-00-00', 3000.00, 3000.00, 0.00, 0.00, 'unpaid'),
(24, 14, 1, 'VCHR-1024', '2025-10', '2025-10-26', '0000-00-00', 4000.00, 4000.00, 0.00, 0.00, 'unpaid');

-- --------------------------------------------------------

--
-- Table structure for table `fee_invoice_items`
--

CREATE TABLE `fee_invoice_items` (
  `id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `head_id` int(11) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `is_discount` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `fee_invoice_items`
--

INSERT INTO `fee_invoice_items` (`id`, `invoice_id`, `head_id`, `description`, `amount`, `is_discount`) VALUES
(22, 22, 1, NULL, 2000.00, 0),
(23, 23, 1, NULL, 3000.00, 0),
(24, 24, 1, NULL, 4000.00, 0);

-- --------------------------------------------------------

--
-- Table structure for table `fee_payments`
--

CREATE TABLE `fee_payments` (
  `id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `payment_date` datetime DEFAULT current_timestamp(),
  `amount` decimal(10,2) NOT NULL,
  `method` enum('Cash','Bank','Online') DEFAULT 'Cash',
  `ref_no` varchar(100) DEFAULT NULL,
  `received_by` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fee_structures`
--

CREATE TABLE `fee_structures` (
  `id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `head_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `cycle` enum('monthly','term','yearly','one-time') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `fee_structures`
--

INSERT INTO `fee_structures` (`id`, `session_id`, `class_id`, `head_id`, `amount`, `cycle`) VALUES
(22, 1, 1, 1, 2000.00, 'monthly'),
(23, 1, 2, 1, 3000.00, 'monthly'),
(24, 1, 3, 1, 4000.00, 'monthly');

-- --------------------------------------------------------

--
-- Table structure for table `other_expenses`
--

CREATE TABLE `other_expenses` (
  `id` int(11) NOT NULL,
  `date` date NOT NULL,
  `expense_type` varchar(100) DEFAULT NULL,
  `expense_head` varchar(100) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `school_leaving_certificates`
--

CREATE TABLE `school_leaving_certificates` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `leaving_class_id` int(11) NOT NULL,
  `issue_date` date NOT NULL,
  `leaving_reason` text DEFAULT NULL,
  `character_remark` varchar(255) DEFAULT NULL,
  `is_edited` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `school_leaving_certificates`
--

INSERT INTO `school_leaving_certificates` (`id`, `student_id`, `leaving_class_id`, `issue_date`, `leaving_reason`, `character_remark`, `is_edited`, `created_at`, `updated_at`) VALUES
(1, 11, 1, '2025-10-25', NULL, NULL, 0, '2025-10-25 13:09:14', '2025-10-25 13:09:14');

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `group_name` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`setting_key`, `setting_value`, `group_name`) VALUES
('academic.active_session_id', '1', 'academic'),
('fee.last_voucher_no', '1024', 'fee'),
('institute.address', 'Block # 13 Sargodha, Punjab, Pakistan', 'institute'),
('institute.logo_path', 'uploads/school_logo_1761221197.png', NULL),
('institute.name', 'Mubeshir Computer Academy', 'institute'),
('institute.phone', '03057442267', 'institute');

-- --------------------------------------------------------

--
-- Table structure for table `students`
--

CREATE TABLE `students` (
  `id` int(11) NOT NULL,
  `gr_no` varchar(50) DEFAULT NULL,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `father_name` varchar(100) NOT NULL,
  `dob` date DEFAULT NULL,
  `gender` enum('Male','Female','Other') NOT NULL,
  `cnic_bform` varchar(20) DEFAULT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `admission_date` date NOT NULL,
  `photo_path` varchar(255) DEFAULT NULL,
  `status` enum('active','inactive','withdrawn') DEFAULT 'active',
  `leaving_date` date DEFAULT NULL,
  `leaving_reason` text DEFAULT NULL,
  `withdrawn_by_user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `students`
--

INSERT INTO `students` (`id`, `gr_no`, `first_name`, `last_name`, `father_name`, `dob`, `gender`, `cnic_bform`, `phone`, `email`, `address`, `admission_date`, `photo_path`, `status`, `leaving_date`, `leaving_reason`, `withdrawn_by_user_id`, `created_at`) VALUES
(12, NULL, 'Mubeshir', 'Mehmood', 'Abdul Hafeez', '2009-09-09', 'Male', NULL, '03057442267', 'mubeshir.official@gmail.com', 'House # 7-S-67, Street # 2 Block # 13 Sargodha', '2025-10-26', NULL, 'active', NULL, NULL, NULL, '2025-10-26 06:56:18'),
(13, NULL, 'Mubeshir', 'Mehmood', 'Abdul Hafeez', '2008-08-08', 'Male', NULL, '03057442267', 'mubeshir.official@gmail.com', 'House # 7-S-67, Street # 2 Block # 13 Sargodha', '2025-10-26', NULL, 'active', NULL, NULL, NULL, '2025-10-26 08:13:53'),
(14, NULL, 'Mubeshir', 'Mehmood', 'Abdul Hafeez', '2007-07-07', 'Male', NULL, '03057442267', 'mubeshir.official@gmail.com', 'House # 7-S-67, Street # 2 Block # 13 Sargodha', '2025-10-26', NULL, 'active', NULL, NULL, NULL, '2025-10-26 08:14:21');

-- --------------------------------------------------------

--
-- Table structure for table `student_enrollments`
--

CREATE TABLE `student_enrollments` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `roll_no` varchar(10) DEFAULT NULL,
  `status` enum('active','promoted','left') DEFAULT 'active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `student_enrollments`
--

INSERT INTO `student_enrollments` (`id`, `student_id`, `session_id`, `class_id`, `section_id`, `roll_no`, `status`) VALUES
(10, 12, 1, 1, 1, '1', 'active'),
(11, 13, 1, 2, 1, '1', 'active'),
(12, 14, 1, 3, 1, '1', 'active');

-- --------------------------------------------------------

--
-- Table structure for table `student_fee_discounts`
--

CREATE TABLE `student_fee_discounts` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `head_id` int(11) DEFAULT NULL,
  `type` enum('fixed','percentage') NOT NULL,
  `value` decimal(5,2) NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `student_results`
--

CREATE TABLE `student_results` (
  `id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `total_marks_obtained` decimal(6,2) NOT NULL,
  `total_max_marks` int(6) NOT NULL,
  `percentage` decimal(5,2) NOT NULL,
  `grade` varchar(10) DEFAULT NULL,
  `result_status` enum('Pass','Fail','Promoted') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `subjects`
--

CREATE TABLE `subjects` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `code` varchar(20) DEFAULT NULL,
  `type` enum('core','elective','optional') DEFAULT 'core'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `subjects`
--

INSERT INTO `subjects` (`id`, `name`, `code`, `type`) VALUES
(7, 'Math', NULL, 'core'),
(8, 'Urdu', NULL, 'core'),
(9, 'English', NULL, 'core'),
(10, 'Islamiat', NULL, 'core'),
(11, 'Drawing', NULL, 'core');

-- --------------------------------------------------------

--
-- Table structure for table `teachers`
--

CREATE TABLE `teachers` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `emp_no` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `designation` varchar(50) DEFAULT NULL,
  `qualification` varchar(100) DEFAULT NULL,
  `cnic` varchar(15) DEFAULT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `salary` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` enum('active','inactive') DEFAULT 'active',
  `photo_path` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `teachers`
--

INSERT INTO `teachers` (`id`, `user_id`, `emp_no`, `name`, `designation`, `qualification`, `cnic`, `phone`, `joining_date`, `salary`, `status`, `photo_path`) VALUES
(1, NULL, '', 'Mubeshir Mehmood', 'Teacher', 'Graduate', '3840393218793', '03057442267', '2025-10-22', 5000.00, 'active', 'default.png');

-- --------------------------------------------------------

--
-- Table structure for table `teacher_deductions`
--

CREATE TABLE `teacher_deductions` (
  `id` int(11) NOT NULL,
  `slip_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `teacher_deductions`
--

INSERT INTO `teacher_deductions` (`id`, `slip_id`, `amount`, `reason`, `created_at`) VALUES
(1, 10, 100.00, 'Late', '2025-10-25 14:51:14');

-- --------------------------------------------------------

--
-- Table structure for table `teacher_salary_items`
--

CREATE TABLE `teacher_salary_items` (
  `id` int(11) NOT NULL,
  `slip_id` int(11) NOT NULL,
  `item_type` enum('allowance','deduction','attendance') NOT NULL,
  `item_description` varchar(255) NOT NULL,
  `amount` decimal(10,2) NOT NULL DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `teacher_salary_items`
--

INSERT INTO `teacher_salary_items` (`id`, `slip_id`, `item_type`, `item_description`, `amount`) VALUES
(10, 10, 'allowance', 'Base Monthly Salary', 5000.00),
(11, 10, 'deduction', 'Late', 100.00);

-- --------------------------------------------------------

--
-- Table structure for table `teacher_salary_slips`
--

CREATE TABLE `teacher_salary_slips` (
  `id` int(11) NOT NULL,
  `teacher_id` int(11) NOT NULL,
  `month_year` date NOT NULL COMMENT 'YYYY-MM-01 format',
  `gross_salary` decimal(10,2) NOT NULL DEFAULT 0.00,
  `total_deduction` decimal(10,2) NOT NULL DEFAULT 0.00,
  `total_deductions` decimal(10,2) NOT NULL DEFAULT 0.00,
  `net_paid` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` enum('generated','paid','cancelled') NOT NULL DEFAULT 'generated',
  `paid_date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `teacher_salary_slips`
--

INSERT INTO `teacher_salary_slips` (`id`, `teacher_id`, `month_year`, `gross_salary`, `total_deduction`, `total_deductions`, `net_paid`, `status`, `paid_date`, `created_at`) VALUES
(10, 1, '2025-10-01', 5000.00, 100.00, 0.00, 4900.00, 'generated', NULL, '2025-10-25 09:29:37');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `role_id` int(11) NOT NULL,
  `teacher_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `license_status` varchar(20) DEFAULT 'Active',
  `license_expiry_date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `password_hash`, `role_id`, `teacher_id`, `name`, `email`, `status`, `license_status`, `license_expiry_date`, `created_at`) VALUES
(1, 'admin', '$2y$10$U/eabCFZkB2M0o.Nt9h5g.qksABb2hVhnEIpnpomE1TP96BoavujC', 1, NULL, 'System Admin', NULL, 'active', 'Active', NULL, '2025-10-21 10:45:29');

-- --------------------------------------------------------

--
-- Table structure for table `user_roles`
--

CREATE TABLE `user_roles` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user_roles`
--

INSERT INTO `user_roles` (`id`, `name`) VALUES
(4, 'Accountant'),
(1, 'Admin'),
(3, 'Librarian'),
(2, 'Teacher');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `academic_classes`
--
ALTER TABLE `academic_classes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `academic_sections`
--
ALTER TABLE `academic_sections`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `academic_sessions`
--
ALTER TABLE `academic_sessions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `class_exam_structure`
--
ALTER TABLE `class_exam_structure`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `exam_id` (`exam_id`,`class_id`,`subject_id`),
  ADD UNIQUE KEY `unique_exam_class_subject` (`exam_id`,`class_id`,`subject_id`),
  ADD UNIQUE KEY `unique_exam_class_subject_new` (`exam_id`,`class_id`,`subject_id`),
  ADD UNIQUE KEY `unique_exam_class_subject_custom` (`exam_id`,`class_id`,`subject_id`),
  ADD KEY `class_id` (`class_id`),
  ADD KEY `subject_id` (`subject_id`);

--
-- Indexes for table `class_sections`
--
ALTER TABLE `class_sections`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`,`class_id`,`section_id`),
  ADD KEY `class_id` (`class_id`),
  ADD KEY `section_id` (`section_id`),
  ADD KEY `class_teacher_id` (`class_teacher_id`);

--
-- Indexes for table `course_allocation`
--
ALTER TABLE `course_allocation`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`,`class_id`,`section_id`,`subject_id`),
  ADD KEY `class_id` (`class_id`),
  ADD KEY `section_id` (`section_id`),
  ADD KEY `subject_id` (`subject_id`),
  ADD KEY `teacher_id` (`teacher_id`);

--
-- Indexes for table `daily_attendance_records`
--
ALTER TABLE `daily_attendance_records`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sheet_id` (`sheet_id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `daily_attendance_sheets`
--
ALTER TABLE `daily_attendance_sheets`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`,`class_id`,`section_id`,`attendance_date`),
  ADD KEY `recorded_by_teacher_id` (`recorded_by_teacher_id`),
  ADD KEY `section_id` (`section_id`);

--
-- Indexes for table `exams`
--
ALTER TABLE `exams`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`,`name`);

--
-- Indexes for table `exam_marks`
--
ALTER TABLE `exam_marks`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `exam_id` (`exam_id`,`student_id`,`subject_id`),
  ADD KEY `student_id` (`student_id`),
  ADD KEY `subject_id` (`subject_id`);

--
-- Indexes for table `fee_heads`
--
ALTER TABLE `fee_heads`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `fee_invoices`
--
ALTER TABLE `fee_invoices`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `voucher_no` (`voucher_no`),
  ADD KEY `student_id` (`student_id`),
  ADD KEY `session_id` (`session_id`);

--
-- Indexes for table `fee_invoice_items`
--
ALTER TABLE `fee_invoice_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoice_id` (`invoice_id`),
  ADD KEY `head_id` (`head_id`);

--
-- Indexes for table `fee_payments`
--
ALTER TABLE `fee_payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoice_id` (`invoice_id`),
  ADD KEY `received_by` (`received_by`);

--
-- Indexes for table `fee_structures`
--
ALTER TABLE `fee_structures`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`,`class_id`,`head_id`),
  ADD KEY `class_id` (`class_id`),
  ADD KEY `head_id` (`head_id`);

--
-- Indexes for table `other_expenses`
--
ALTER TABLE `other_expenses`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `school_leaving_certificates`
--
ALTER TABLE `school_leaving_certificates`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_student_session` (`student_id`,`leaving_class_id`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`setting_key`);

--
-- Indexes for table `students`
--
ALTER TABLE `students`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `gr_no` (`gr_no`),
  ADD UNIQUE KEY `cnic_bform` (`cnic_bform`);

--
-- Indexes for table `student_enrollments`
--
ALTER TABLE `student_enrollments`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `student_id` (`student_id`,`session_id`),
  ADD KEY `session_id` (`session_id`),
  ADD KEY `class_id` (`class_id`),
  ADD KEY `section_id` (`section_id`);

--
-- Indexes for table `student_fee_discounts`
--
ALTER TABLE `student_fee_discounts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`),
  ADD KEY `head_id` (`head_id`);

--
-- Indexes for table `student_results`
--
ALTER TABLE `student_results`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `exam_id` (`exam_id`,`student_id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `subjects`
--
ALTER TABLE `subjects`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `teachers`
--
ALTER TABLE `teachers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `emp_no` (`emp_no`),
  ADD UNIQUE KEY `cnic` (`cnic`);

--
-- Indexes for table `teacher_deductions`
--
ALTER TABLE `teacher_deductions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `slip_id` (`slip_id`);

--
-- Indexes for table `teacher_salary_items`
--
ALTER TABLE `teacher_salary_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `slip_id` (`slip_id`);

--
-- Indexes for table `teacher_salary_slips`
--
ALTER TABLE `teacher_salary_slips`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_teacher_month` (`teacher_id`,`month_year`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `role_id` (`role_id`),
  ADD KEY `teacher_id` (`teacher_id`);

--
-- Indexes for table `user_roles`
--
ALTER TABLE `user_roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `academic_classes`
--
ALTER TABLE `academic_classes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `academic_sections`
--
ALTER TABLE `academic_sections`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `academic_sessions`
--
ALTER TABLE `academic_sessions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `class_exam_structure`
--
ALTER TABLE `class_exam_structure`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=23;

--
-- AUTO_INCREMENT for table `class_sections`
--
ALTER TABLE `class_sections`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `course_allocation`
--
ALTER TABLE `course_allocation`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

--
-- AUTO_INCREMENT for table `daily_attendance_records`
--
ALTER TABLE `daily_attendance_records`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `daily_attendance_sheets`
--
ALTER TABLE `daily_attendance_sheets`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `exams`
--
ALTER TABLE `exams`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `exam_marks`
--
ALTER TABLE `exam_marks`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=70;

--
-- AUTO_INCREMENT for table `fee_heads`
--
ALTER TABLE `fee_heads`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `fee_invoices`
--
ALTER TABLE `fee_invoices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;

--
-- AUTO_INCREMENT for table `fee_invoice_items`
--
ALTER TABLE `fee_invoice_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;

--
-- AUTO_INCREMENT for table `fee_payments`
--
ALTER TABLE `fee_payments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `fee_structures`
--
ALTER TABLE `fee_structures`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;

--
-- AUTO_INCREMENT for table `other_expenses`
--
ALTER TABLE `other_expenses`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `school_leaving_certificates`
--
ALTER TABLE `school_leaving_certificates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `students`
--
ALTER TABLE `students`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT for table `student_enrollments`
--
ALTER TABLE `student_enrollments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `student_fee_discounts`
--
ALTER TABLE `student_fee_discounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `student_results`
--
ALTER TABLE `student_results`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `subjects`
--
ALTER TABLE `subjects`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `teachers`
--
ALTER TABLE `teachers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `teacher_deductions`
--
ALTER TABLE `teacher_deductions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `teacher_salary_items`
--
ALTER TABLE `teacher_salary_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `teacher_salary_slips`
--
ALTER TABLE `teacher_salary_slips`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `user_roles`
--
ALTER TABLE `user_roles`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `class_exam_structure`
--
ALTER TABLE `class_exam_structure`
  ADD CONSTRAINT `class_exam_structure_ibfk_1` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`),
  ADD CONSTRAINT `class_exam_structure_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `academic_classes` (`id`),
  ADD CONSTRAINT `class_exam_structure_ibfk_3` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`);

--
-- Constraints for table `class_sections`
--
ALTER TABLE `class_sections`
  ADD CONSTRAINT `class_sections_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `academic_sessions` (`id`),
  ADD CONSTRAINT `class_sections_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `academic_classes` (`id`),
  ADD CONSTRAINT `class_sections_ibfk_3` FOREIGN KEY (`section_id`) REFERENCES `academic_sections` (`id`),
  ADD CONSTRAINT `class_sections_ibfk_4` FOREIGN KEY (`class_teacher_id`) REFERENCES `teachers` (`id`);

--
-- Constraints for table `course_allocation`
--
ALTER TABLE `course_allocation`
  ADD CONSTRAINT `course_allocation_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `academic_sessions` (`id`),
  ADD CONSTRAINT `course_allocation_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `academic_classes` (`id`),
  ADD CONSTRAINT `course_allocation_ibfk_3` FOREIGN KEY (`section_id`) REFERENCES `academic_sections` (`id`),
  ADD CONSTRAINT `course_allocation_ibfk_4` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`),
  ADD CONSTRAINT `course_allocation_ibfk_5` FOREIGN KEY (`teacher_id`) REFERENCES `teachers` (`id`);

--
-- Constraints for table `daily_attendance_records`
--
ALTER TABLE `daily_attendance_records`
  ADD CONSTRAINT `daily_attendance_records_ibfk_1` FOREIGN KEY (`sheet_id`) REFERENCES `daily_attendance_sheets` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `daily_attendance_records_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`);

--
-- Constraints for table `daily_attendance_sheets`
--
ALTER TABLE `daily_attendance_sheets`
  ADD CONSTRAINT `daily_attendance_sheets_ibfk_1` FOREIGN KEY (`recorded_by_teacher_id`) REFERENCES `teachers` (`id`),
  ADD CONSTRAINT `daily_attendance_sheets_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `academic_sections` (`id`);

--
-- Constraints for table `exams`
--
ALTER TABLE `exams`
  ADD CONSTRAINT `exams_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `academic_sessions` (`id`);

--
-- Constraints for table `exam_marks`
--
ALTER TABLE `exam_marks`
  ADD CONSTRAINT `exam_marks_ibfk_1` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`),
  ADD CONSTRAINT `exam_marks_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`),
  ADD CONSTRAINT `exam_marks_ibfk_3` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`);

--
-- Constraints for table `fee_invoices`
--
ALTER TABLE `fee_invoices`
  ADD CONSTRAINT `fee_invoices_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`),
  ADD CONSTRAINT `fee_invoices_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `academic_sessions` (`id`);

--
-- Constraints for table `fee_invoice_items`
--
ALTER TABLE `fee_invoice_items`
  ADD CONSTRAINT `fee_invoice_items_ibfk_1` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`),
  ADD CONSTRAINT `fee_invoice_items_ibfk_2` FOREIGN KEY (`head_id`) REFERENCES `fee_heads` (`id`);

--
-- Constraints for table `fee_payments`
--
ALTER TABLE `fee_payments`
  ADD CONSTRAINT `fee_payments_ibfk_1` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`),
  ADD CONSTRAINT `fee_payments_ibfk_2` FOREIGN KEY (`received_by`) REFERENCES `users` (`id`);

--
-- Constraints for table `fee_structures`
--
ALTER TABLE `fee_structures`
  ADD CONSTRAINT `fee_structures_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `academic_sessions` (`id`),
  ADD CONSTRAINT `fee_structures_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `academic_classes` (`id`),
  ADD CONSTRAINT `fee_structures_ibfk_3` FOREIGN KEY (`head_id`) REFERENCES `fee_heads` (`id`);

--
-- Constraints for table `student_enrollments`
--
ALTER TABLE `student_enrollments`
  ADD CONSTRAINT `student_enrollments_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`),
  ADD CONSTRAINT `student_enrollments_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `academic_sessions` (`id`),
  ADD CONSTRAINT `student_enrollments_ibfk_3` FOREIGN KEY (`class_id`) REFERENCES `academic_classes` (`id`),
  ADD CONSTRAINT `student_enrollments_ibfk_4` FOREIGN KEY (`section_id`) REFERENCES `academic_sections` (`id`);

--
-- Constraints for table `student_fee_discounts`
--
ALTER TABLE `student_fee_discounts`
  ADD CONSTRAINT `student_fee_discounts_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`),
  ADD CONSTRAINT `student_fee_discounts_ibfk_2` FOREIGN KEY (`head_id`) REFERENCES `fee_heads` (`id`);

--
-- Constraints for table `student_results`
--
ALTER TABLE `student_results`
  ADD CONSTRAINT `student_results_ibfk_1` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`),
  ADD CONSTRAINT `student_results_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`);

--
-- Constraints for table `teacher_deductions`
--
ALTER TABLE `teacher_deductions`
  ADD CONSTRAINT `teacher_deductions_ibfk_1` FOREIGN KEY (`slip_id`) REFERENCES `teacher_salary_slips` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `teacher_salary_items`
--
ALTER TABLE `teacher_salary_items`
  ADD CONSTRAINT `teacher_salary_items_ibfk_1` FOREIGN KEY (`slip_id`) REFERENCES `teacher_salary_slips` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `teacher_salary_slips`
--
ALTER TABLE `teacher_salary_slips`
  ADD CONSTRAINT `teacher_salary_slips_ibfk_1` FOREIGN KEY (`teacher_id`) REFERENCES `teachers` (`id`);

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `user_roles` (`id`),
  ADD CONSTRAINT `users_ibfk_2` FOREIGN KEY (`teacher_id`) REFERENCES `teachers` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
