-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Dec 15, 2025 at 01:18 PM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `ammo`
--

-- --------------------------------------------------------

--
-- Table structure for table `academic_classes`
--

CREATE TABLE `academic_classes` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `code` varchar(10) DEFAULT NULL,
  `order_no` int(11) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `academic_classes`
--

INSERT INTO `academic_classes` (`id`, `name`, `code`, `order_no`) VALUES
(1, 'Play Group', NULL, 0),
(2, 'Nursery', NULL, 0),
(3, 'Prep', NULL, 0),
(5, 'One', 'ONE', 0);

-- --------------------------------------------------------

--
-- Table structure for table `academic_sections`
--

CREATE TABLE `academic_sections` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `status` enum('active','inactive') DEFAULT 'active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `academic_sections`
--

INSERT INTO `academic_sections` (`id`, `name`, `status`) VALUES
(1, 'A', 'active'),
(2, 'B', 'active'),
(3, 'C', 'active');

-- --------------------------------------------------------

--
-- Table structure for table `academic_sessions`
--

CREATE TABLE `academic_sessions` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `is_active` tinyint(1) DEFAULT 0,
  `status` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `academic_sessions`
--

INSERT INTO `academic_sessions` (`id`, `name`, `start_date`, `end_date`, `is_active`, `status`) VALUES
(1, '2024-2025', '2024-08-25', '2026-11-25', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `class_exam_structure`
--

CREATE TABLE `class_exam_structure` (
  `id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `total_marks` int(4) NOT NULL,
  `passing_marks` int(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `class_exam_structure`
--

INSERT INTO `class_exam_structure` (`id`, `exam_id`, `class_id`, `subject_id`, `total_marks`, `passing_marks`) VALUES
(31, 5, 1, 9, 50, 17),
(32, 5, 1, 10, 50, 17),
(33, 5, 1, 7, 50, 17),
(34, 5, 1, 8, 50, 17),
(35, 5, 2, 11, 50, 17),
(36, 5, 2, 9, 50, 17),
(37, 5, 2, 10, 50, 17),
(38, 5, 2, 7, 50, 17),
(39, 5, 2, 8, 50, 17),
(40, 6, 1, 9, 50, 17),
(41, 6, 1, 10, 50, 17),
(42, 6, 1, 7, 50, 17),
(43, 6, 1, 8, 50, 17),
(44, 6, 2, 11, 50, 17),
(45, 6, 2, 9, 50, 17),
(46, 6, 2, 10, 50, 17),
(47, 6, 2, 7, 50, 17),
(48, 6, 2, 8, 50, 17),
(49, 7, 1, 9, 100, 33),
(50, 7, 1, 10, 100, 33),
(51, 7, 1, 7, 100, 33),
(52, 7, 1, 8, 100, 33),
(53, 7, 2, 11, 100, 33),
(54, 7, 2, 9, 100, 33),
(55, 7, 2, 10, 100, 33),
(56, 7, 2, 7, 100, 33),
(57, 7, 2, 8, 100, 33);

-- --------------------------------------------------------

--
-- Table structure for table `class_sections`
--

CREATE TABLE `class_sections` (
  `id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `class_teacher_id` int(11) DEFAULT NULL,
  `capacity` int(11) DEFAULT 40
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `class_syllabus`
--

CREATE TABLE `class_syllabus` (
  `id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `syllabus_type` enum('term_wise','summer_vacation') NOT NULL,
  `academic_year` varchar(20) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `original_name` varchar(255) NOT NULL,
  `file_path` varchar(500) NOT NULL,
  `file_size` int(11) NOT NULL,
  `uploaded_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `class_syllabus`
--

INSERT INTO `class_syllabus` (`id`, `class_id`, `syllabus_type`, `academic_year`, `file_name`, `original_name`, `file_path`, `file_size`, `uploaded_at`) VALUES
(1, 1, 'summer_vacation', '2025-2026', 'syllabus_1_summer_vacation_1764180471.pdf', 'ems 9th.pdf', '../uploads/syllabus/syllabus_1_summer_vacation_1764180471.pdf', 251951, '2025-11-26 23:07:51');

-- --------------------------------------------------------

--
-- Table structure for table `course_allocation`
--

CREATE TABLE `course_allocation` (
  `id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) DEFAULT NULL,
  `subject_id` int(11) NOT NULL,
  `teacher_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `course_allocation`
--

INSERT INTO `course_allocation` (`id`, `session_id`, `class_id`, `section_id`, `subject_id`, `teacher_id`) VALUES
(5, 1, 1, 1, 9, 1),
(6, 1, 1, 1, 10, 1),
(7, 1, 1, 1, 7, 1),
(8, 1, 1, 1, 8, 1),
(9, 1, 3, NULL, 11, 1),
(10, 1, 3, NULL, 9, 1),
(11, 1, 3, NULL, 10, 1),
(12, 1, 3, NULL, 7, 1),
(13, 1, 3, NULL, 8, 1),
(14, 1, 2, NULL, 11, 1),
(15, 1, 2, NULL, 9, 1),
(16, 1, 2, NULL, 10, 1),
(17, 1, 2, NULL, 7, 1),
(18, 1, 2, NULL, 8, 1),
(19, 1, 5, 1, 11, 1),
(20, 1, 5, 1, 9, 1),
(21, 1, 5, 1, 10, 1),
(22, 1, 5, 1, 7, 1),
(23, 1, 5, 1, 8, 1);

-- --------------------------------------------------------

--
-- Table structure for table `daily_attendance_records`
--

CREATE TABLE `daily_attendance_records` (
  `id` int(11) NOT NULL,
  `sheet_id` int(11) NOT NULL,
  `attendance_date` date DEFAULT NULL,
  `student_id` int(11) NOT NULL,
  `status` enum('Present','Absent','Leave','Late') NOT NULL,
  `note` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `daily_attendance_records`
--

INSERT INTO `daily_attendance_records` (`id`, `sheet_id`, `attendance_date`, `student_id`, `status`, `note`) VALUES
(51, 22, NULL, 29, 'Present', ''),
(52, 22, NULL, 31, 'Present', ''),
(53, 23, NULL, 32, 'Present', ''),
(54, 23, NULL, 33, 'Absent', '');

-- --------------------------------------------------------

--
-- Table structure for table `daily_attendance_sheets`
--

CREATE TABLE `daily_attendance_sheets` (
  `id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `attendance_date` date NOT NULL,
  `recorded_by_teacher_id` int(11) DEFAULT NULL,
  `is_locked` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `daily_attendance_sheets`
--

INSERT INTO `daily_attendance_sheets` (`id`, `session_id`, `class_id`, `section_id`, `attendance_date`, `recorded_by_teacher_id`, `is_locked`, `created_at`) VALUES
(3, 0, 1, 1, '2025-10-22', 1, 0, '2025-10-22 10:21:48'),
(4, 0, 1, 1, '2025-10-24', 1, 0, '2025-10-24 06:50:42'),
(5, 0, 1, 1, '2025-10-01', 1, 0, '2025-10-24 12:20:03'),
(6, 0, 1, 1, '2025-10-14', 1, 0, '2025-10-24 12:20:10'),
(7, 0, 1, 1, '2025-10-23', 1, 0, '2025-10-24 12:20:17'),
(8, 0, 1, 1, '2025-10-25', 1, 0, '2025-10-25 08:42:29'),
(9, 0, 1, 1, '2025-10-26', 1, 0, '2025-10-26 08:19:30'),
(10, 0, 2, 1, '2025-10-26', 1, 0, '2025-10-26 08:19:34'),
(11, 0, 3, 1, '2025-10-26', 1, 0, '2025-10-26 08:19:38'),
(12, 0, 1, 1, '2025-11-02', 1, 0, '2025-11-02 10:07:32'),
(13, 0, 1, 1, '2025-11-13', 1, 0, '2025-11-13 13:05:46'),
(15, 0, 1, 1, '2025-11-12', 1, 0, '2025-11-13 13:55:56'),
(16, 0, 1, 1, '2025-11-11', 1, 0, '2025-11-13 13:56:02'),
(17, 0, 1, 1, '2025-11-10', 1, 0, '2025-11-13 13:56:08'),
(18, 0, 1, 1, '2025-11-09', 1, 0, '2025-11-13 13:56:13'),
(19, 0, 1, 1, '2025-11-01', 1, 0, '2025-11-16 06:21:12'),
(21, 0, 1, 1, '2025-11-03', 1, 0, '2025-11-16 06:24:24'),
(22, 0, 1, 1, '2025-11-25', 1, 0, '2025-11-25 19:10:34'),
(23, 0, 2, 1, '2025-11-25', 1, 0, '2025-11-25 19:11:03');

-- --------------------------------------------------------

--
-- Table structure for table `daily_planner`
--

CREATE TABLE `daily_planner` (
  `id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `planner_date` date NOT NULL,
  `cw_content` text DEFAULT NULL,
  `hw_content` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `exams`
--

CREATE TABLE `exams` (
  `id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` enum('term','final') DEFAULT 'term',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` enum('active','completed') DEFAULT 'active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `exams`
--

INSERT INTO `exams` (`id`, `session_id`, `name`, `type`, `start_date`, `end_date`, `status`) VALUES
(5, 1, 'First Term Exam 2025-26', 'term', '2025-11-25', '2025-11-26', 'completed'),
(6, 1, 'Second Term Exam 2025-26', 'term', '2025-11-25', '2025-11-26', 'completed'),
(7, 1, 'Finel Term Exam 2025-26', 'term', '2025-11-25', '2025-11-26', 'active');

-- --------------------------------------------------------

--
-- Table structure for table `exam_datesheet`
--

CREATE TABLE `exam_datesheet` (
  `exam_id` int(11) NOT NULL COMMENT 'FK to exams table',
  `class_id` int(11) NOT NULL COMMENT 'FK to academic_classes table',
  `subject_id` int(11) NOT NULL COMMENT 'FK to subjects table',
  `exam_date` date NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `total_marks` int(11) DEFAULT 100,
  `passing_marks` int(11) DEFAULT 40,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `exam_datesheet`
--

INSERT INTO `exam_datesheet` (`exam_id`, `class_id`, `subject_id`, `exam_date`, `start_time`, `end_time`, `total_marks`, `passing_marks`, `created_at`) VALUES
(3, 1, 9, '2025-11-10', '00:00:00', '00:00:00', 0, 0, '2025-11-09 17:23:19'),
(3, 1, 10, '2025-11-11', '00:00:00', '00:00:00', 0, 0, '2025-11-09 17:23:19'),
(3, 1, 8, '2025-11-12', '00:00:00', '00:00:00', 0, 0, '2025-11-09 17:23:19'),
(3, 2, 9, '2025-11-10', '00:00:00', '00:00:00', 0, 0, '2025-11-09 17:23:19'),
(3, 2, 10, '2025-11-11', '00:00:00', '00:00:00', 0, 0, '2025-11-09 17:23:19'),
(3, 2, 8, '2025-11-12', '00:00:00', '00:00:00', 0, 0, '2025-11-09 17:23:19'),
(3, 3, 9, '2025-11-10', '00:00:00', '00:00:00', 0, 0, '2025-11-09 17:23:19'),
(3, 3, 10, '2025-11-11', '00:00:00', '00:00:00', 0, 0, '2025-11-09 17:23:19'),
(3, 3, 8, '2025-11-12', '00:00:00', '00:00:00', 0, 0, '2025-11-09 17:23:19'),
(5, 1, 0, '2025-11-30', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 1, 9, '2025-12-01', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 1, 10, '2025-12-02', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 1, 7, '2025-12-03', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 1, 8, '2025-12-04', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 2, 0, '2025-11-30', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 2, 9, '2025-12-01', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 2, 10, '2025-12-02', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 2, 7, '2025-12-03', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 2, 8, '2025-12-04', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 3, 0, '2025-11-30', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 3, 9, '2025-12-01', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 3, 10, '2025-12-02', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 3, 7, '2025-12-03', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 3, 8, '2025-12-04', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 5, 0, '2025-11-30', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 5, 9, '2025-12-01', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 5, 10, '2025-12-02', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 5, 7, '2025-12-03', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18'),
(5, 5, 8, '2025-12-04', '00:00:00', '00:00:00', 0, 0, '2025-11-30 15:57:18');

-- --------------------------------------------------------

--
-- Table structure for table `exam_marks`
--

CREATE TABLE `exam_marks` (
  `id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `marks_obtained` decimal(5,2) NOT NULL,
  `is_absent` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `exam_marks`
--

INSERT INTO `exam_marks` (`id`, `exam_id`, `student_id`, `class_id`, `subject_id`, `marks_obtained`, `is_absent`) VALUES
(134, 5, 29, 1, 9, 20.00, 0),
(135, 5, 29, 1, 10, 20.00, 0),
(136, 5, 29, 1, 7, 0.00, 1),
(137, 5, 29, 1, 8, 20.00, 0),
(142, 5, 31, 1, 9, 25.00, 0),
(143, 5, 31, 1, 10, 25.00, 0),
(144, 5, 31, 1, 7, 25.00, 0),
(145, 5, 31, 1, 8, 25.00, 0),
(146, 5, 32, 2, 11, 22.00, 0),
(147, 5, 32, 2, 9, 22.00, 0),
(148, 5, 32, 2, 10, 22.00, 0),
(149, 5, 32, 2, 7, 22.00, 0),
(150, 5, 32, 2, 8, 22.00, 0),
(156, 5, 33, 2, 11, 24.00, 0),
(157, 5, 33, 2, 9, 24.00, 0),
(158, 5, 33, 2, 10, 24.00, 0),
(159, 5, 33, 2, 7, 24.00, 0),
(160, 5, 33, 2, 8, 24.00, 0),
(161, 6, 29, 1, 9, 26.00, 0),
(162, 6, 29, 1, 10, 26.00, 0),
(163, 6, 29, 1, 7, 26.00, 0),
(164, 6, 29, 1, 8, 26.00, 0),
(165, 6, 31, 1, 9, 40.00, 0),
(166, 6, 31, 1, 10, 40.00, 0),
(167, 6, 31, 1, 7, 40.00, 0),
(168, 6, 31, 1, 8, 40.00, 0),
(169, 6, 32, 2, 11, 45.00, 0),
(170, 6, 32, 2, 9, 45.00, 0),
(171, 6, 32, 2, 10, 45.00, 0),
(172, 6, 32, 2, 7, 45.00, 0),
(173, 6, 32, 2, 8, 45.00, 0),
(174, 6, 33, 2, 11, 45.00, 0),
(175, 6, 33, 2, 9, 45.00, 0),
(176, 6, 33, 2, 10, 45.00, 0),
(177, 6, 33, 2, 7, 45.00, 0),
(178, 6, 33, 2, 8, 45.00, 0),
(179, 7, 29, 1, 9, 85.00, 0),
(180, 7, 29, 1, 10, 85.00, 0),
(181, 7, 29, 1, 7, 85.00, 0),
(182, 7, 29, 1, 8, 85.00, 0),
(183, 7, 31, 1, 9, 90.00, 0),
(184, 7, 31, 1, 10, 90.00, 0),
(185, 7, 31, 1, 7, 90.00, 0),
(186, 7, 31, 1, 8, 30.00, 0),
(187, 7, 32, 2, 11, 100.00, 0),
(188, 7, 32, 2, 9, 40.00, 0),
(189, 7, 32, 2, 10, 50.00, 0),
(190, 7, 32, 2, 7, 60.00, 0),
(191, 7, 32, 2, 8, 70.00, 0),
(192, 7, 33, 2, 11, 28.00, 0),
(193, 7, 33, 2, 9, 34.00, 0),
(194, 7, 33, 2, 10, 85.00, 0),
(195, 7, 33, 2, 7, 90.00, 0),
(196, 7, 33, 2, 8, 100.00, 0);

-- --------------------------------------------------------

--
-- Table structure for table `fee_heads`
--

CREATE TABLE `fee_heads` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` enum('fee','discount','fine') NOT NULL DEFAULT 'fee',
  `is_recurring` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `fee_heads`
--

INSERT INTO `fee_heads` (`id`, `name`, `type`, `is_recurring`) VALUES
(1, 'Tuition Fee', 'fee', 1),
(2, 'Admission Fee', 'fee', 0),
(3, 'Exam Fee', 'fee', 0),
(4, 'Transport Fee', '', 1),
(5, 'Scholarship/Concession', 'discount', 0),
(6, 'Late Payment Fine', 'fine', 0);

-- --------------------------------------------------------

--
-- Table structure for table `fee_invoices`
--

CREATE TABLE `fee_invoices` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `voucher_no` varchar(50) NOT NULL,
  `month_year` varchar(7) NOT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `net_payable` decimal(10,2) NOT NULL DEFAULT 0.00,
  `amount_paid` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` enum('pending','paid','cancelled','unpaid','partial') NOT NULL DEFAULT 'unpaid',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `fee_invoices`
--

INSERT INTO `fee_invoices` (`id`, `student_id`, `session_id`, `voucher_no`, `month_year`, `issue_date`, `due_date`, `total_amount`, `net_payable`, `amount_paid`, `status`, `created_at`) VALUES
(22, 29, 1, 'VCHR-1164', '2025-11', '2025-11-25', '2025-12-05', 2000.00, 2000.00, 2000.00, 'paid', '2025-11-25 19:12:09'),
(23, 32, 1, 'VCHR-1165', '2025-11', '2025-11-25', '2025-12-05', 2000.00, 2000.00, 2000.00, 'paid', '2025-11-25 19:12:09'),
(24, 33, 1, 'VCHR-1166', '2025-11', '2025-11-25', '2025-12-05', 2000.00, 2000.00, 2000.00, 'paid', '2025-11-25 19:12:09'),
(25, 31, 1, 'VCHR-1167', '2025-11', '2025-11-25', '2025-12-05', 2000.00, 2000.00, 2000.00, 'paid', '2025-11-25 19:12:09'),
(26, 34, 1, 'VCHR-1168', '2025-11', '2025-11-26', '2025-12-06', 300.00, 300.00, 0.00, 'unpaid', '2025-11-26 16:53:57'),
(27, 35, 1, 'VCHR-1169', '2025-11', '2025-11-26', '2025-12-06', 2500.00, 2500.00, 0.00, 'unpaid', '2025-11-26 18:23:09');

-- --------------------------------------------------------

--
-- Table structure for table `fee_invoice_items`
--

CREATE TABLE `fee_invoice_items` (
  `id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `fee_type` enum('admission','monthly','examination','other') NOT NULL,
  `description` varchar(255) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `fee_invoice_items`
--

INSERT INTO `fee_invoice_items` (`id`, `invoice_id`, `fee_type`, `description`, `amount`, `created_at`) VALUES
(134, 22, 'monthly', 'Monthly Fee', 2000.00, '2025-11-25 19:12:09'),
(135, 23, 'monthly', 'Monthly Fee', 2000.00, '2025-11-25 19:12:09'),
(136, 24, 'monthly', 'Monthly Fee', 2000.00, '2025-11-25 19:12:09'),
(137, 25, 'monthly', 'Monthly Fee', 2000.00, '2025-11-25 19:12:09'),
(138, 26, 'monthly', 'Monthly Fee', 300.00, '2025-11-26 16:53:57'),
(139, 27, 'monthly', 'Monthly Fee', 2500.00, '2025-11-26 18:23:09');

-- --------------------------------------------------------

--
-- Table structure for table `fee_payments`
--

CREATE TABLE `fee_payments` (
  `id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `payment_date` datetime DEFAULT current_timestamp(),
  `amount` decimal(10,2) NOT NULL,
  `method` enum('Cash','Bank','Online') DEFAULT 'Cash',
  `ref_no` varchar(100) DEFAULT NULL,
  `received_by` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `fee_payments`
--

INSERT INTO `fee_payments` (`id`, `invoice_id`, `payment_date`, `amount`, `method`, `ref_no`, `received_by`, `note`) VALUES
(9, 22, '2025-11-25 00:00:00', 2000.00, 'Cash', NULL, NULL, NULL),
(10, 25, '2025-11-25 00:00:00', 2000.00, 'Cash', NULL, NULL, NULL),
(11, 23, '2025-11-25 00:00:00', 2000.00, 'Cash', NULL, NULL, NULL),
(12, 24, '2025-11-25 00:00:00', 2000.00, 'Cash', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `fee_structures`
--

CREATE TABLE `fee_structures` (
  `id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `head_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `cycle` enum('monthly','term','yearly','one-time') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `fee_structures`
--

INSERT INTO `fee_structures` (`id`, `session_id`, `class_id`, `head_id`, `amount`, `cycle`) VALUES
(25, 1, 1, 1, 2000.00, 'monthly'),
(26, 1, 2, 1, 3000.00, 'monthly'),
(27, 1, 3, 1, 4000.00, 'monthly'),
(28, 1, 5, 1, 5000.00, 'monthly');

-- --------------------------------------------------------

--
-- Table structure for table `notices`
--

CREATE TABLE `notices` (
  `id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `notice_date` date NOT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `notices`
--

INSERT INTO `notices` (`id`, `title`, `description`, `notice_date`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Fee Announcement', 'Please Submit Your fee Before Closing Date', '2025-11-24', 1, '2025-11-24 13:55:07', '2025-11-24 13:55:07');

-- --------------------------------------------------------

--
-- Table structure for table `other_expenses`
--

CREATE TABLE `other_expenses` (
  `id` int(11) NOT NULL,
  `date` date NOT NULL,
  `expense_type` varchar(100) DEFAULT NULL,
  `expense_head` varchar(100) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `other_expenses`
--

INSERT INTO `other_expenses` (`id`, `date`, `expense_type`, `expense_head`, `description`, `amount`, `created_at`) VALUES
(6, '2025-11-25', 'Utilities', '', 'Electricity Bill November', 800.00, '2025-11-25 19:21:12');

-- --------------------------------------------------------

--
-- Table structure for table `parent_student_link`
--

CREATE TABLE `parent_student_link` (
  `id` int(11) NOT NULL,
  `parent_user_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `parent_student_link`
--

INSERT INTO `parent_student_link` (`id`, `parent_user_id`, `student_id`, `created_at`) VALUES
(6, 8, 32, '2025-11-26 18:28:27'),
(7, 8, 31, '2025-11-26 18:28:27');

-- --------------------------------------------------------

--
-- Table structure for table `school_leaving_certificates`
--

CREATE TABLE `school_leaving_certificates` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `leaving_class_id` int(11) NOT NULL,
  `issue_date` date NOT NULL,
  `leaving_reason` text DEFAULT NULL,
  `character_remark` varchar(255) DEFAULT NULL,
  `is_edited` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `school_leaving_certificates`
--

INSERT INTO `school_leaving_certificates` (`id`, `student_id`, `leaving_class_id`, `issue_date`, `leaving_reason`, `character_remark`, `is_edited`, `created_at`, `updated_at`) VALUES
(1, 11, 1, '2025-10-25', NULL, NULL, 0, '2025-10-25 13:09:14', '2025-10-25 13:09:14'),
(2, 25, 3, '2025-11-16', NULL, NULL, 0, '2025-11-16 09:28:47', '2025-11-16 09:28:47'),
(4, 34, 1, '2025-11-30', NULL, NULL, 0, '2025-11-30 15:53:22', '2025-11-30 15:53:22');

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `group_name` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`setting_key`, `setting_value`, `group_name`) VALUES
('academic.active_session_id', '1', 'academic'),
('fee.last_voucher_no', '1169', 'fee'),
('institute.address', 'Block # 14 Sargodha, Punjab, Pakistan', 'institute'),
('institute.logo_path', 'uploads/school_logo_1764517943.jpg', NULL),
('institute.name', 'Rose Merry Model School', 'institute'),
('institute.phone', '03057442267', 'institute');

-- --------------------------------------------------------

--
-- Table structure for table `students`
--

CREATE TABLE `students` (
  `id` int(11) NOT NULL,
  `gr_no` varchar(50) DEFAULT NULL,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `father_name` varchar(100) NOT NULL,
  `dob` date DEFAULT NULL,
  `gender` enum('Male','Female','Other') NOT NULL,
  `cnic_bform` varchar(20) DEFAULT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `admission_date` date NOT NULL,
  `photo_path` varchar(255) DEFAULT NULL,
  `status` enum('active','inactive','withdrawn') DEFAULT 'active',
  `leaving_date` date DEFAULT NULL,
  `leaving_reason` text DEFAULT NULL,
  `withdrawn_by_user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `students`
--

INSERT INTO `students` (`id`, `gr_no`, `first_name`, `last_name`, `father_name`, `dob`, `gender`, `cnic_bform`, `phone`, `email`, `address`, `admission_date`, `photo_path`, `status`, `leaving_date`, `leaving_reason`, `withdrawn_by_user_id`, `created_at`) VALUES
(29, 'MCA/REG/0001', 'Marwa', 'Farooq', 'Umar Farooq', '2025-11-25', 'Female', '3840392373293', '03226080094', NULL, 'Umar Farooq House # 7-S-67, Street # 2, Block # 13\r\nNear Olia Mosque', '2025-11-25', NULL, 'active', NULL, NULL, NULL, '2025-11-25 18:34:29'),
(31, 'MCA/REG/0002', 'Abdul', 'Bari', 'Umar Farooq', '2025-11-25', 'Male', '3840392373292', '03226080094', NULL, 'Umar Farooq House # 7-S-67, Street # 2, Block # 13\r\nNear Olia Mosque', '2025-11-25', NULL, 'active', NULL, NULL, NULL, '2025-11-25 18:35:28'),
(32, 'MCA/REG/0003', 'Maryam', 'Farooq', 'Umar Farooq', '2025-11-25', 'Female', '3840392373291', '03226080094', NULL, 'Umar Farooq House # 7-S-67, Street # 2, Block # 13\r\nNear Olia Mosque', '2025-11-25', NULL, 'active', NULL, NULL, NULL, '2025-11-25 18:36:12'),
(33, 'MCA/REG/0004', 'Umme', 'Hani', 'Mubeshir Mehmood', '2025-11-25', 'Female', '3840392373290', '03121713710', NULL, 'House # P-65/14, Block # 13, Mohala Ittefaq Colony, Umar Bagh, Sargodha', '2025-11-25', NULL, 'active', NULL, NULL, NULL, '2025-11-25 18:37:00'),
(34, 'MCA/REG/0005', 'Uzair', '', 'Mubeshir', '2010-09-09', 'Male', '3840393218799', NULL, NULL, NULL, '2025-11-26', NULL, 'withdrawn', '2025-11-30', 'withdrawn', 1, '2025-11-26 16:45:41'),
(35, 'MCA/REG/0006', 'Asad', 'Mehmood', 'Abdul Hafeez', '2021-11-30', 'Male', '3840392373280', '03226080094', NULL, 'Umar Farooq House # 7-S-67, Street # 2, Block # 13\r\nNear Olia Mosque', '2025-11-26', NULL, 'active', NULL, NULL, NULL, '2025-11-26 18:21:33');

-- --------------------------------------------------------

--
-- Table structure for table `student_enrollments`
--

CREATE TABLE `student_enrollments` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `roll_no` varchar(10) DEFAULT NULL,
  `status` enum('active','promoted','left') DEFAULT 'active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `student_enrollments`
--

INSERT INTO `student_enrollments` (`id`, `student_id`, `session_id`, `class_id`, `section_id`, `roll_no`, `status`) VALUES
(21, 29, 1, 2, 1, '1', 'active'),
(22, 31, 1, 1, 1, '2', 'active'),
(23, 32, 1, 1, 1, '1', 'active'),
(24, 33, 1, 2, 1, '2', 'active'),
(25, 34, 1, 1, 1, '3', 'active'),
(26, 35, 1, 1, 1, '4', 'active');

-- --------------------------------------------------------

--
-- Table structure for table `student_fees`
--

CREATE TABLE `student_fees` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `fee_type` enum('admission','monthly','examination','other') NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `month` varchar(20) NOT NULL,
  `academic_year` year(4) NOT NULL,
  `is_one_time` tinyint(1) DEFAULT 0,
  `is_recurring` tinyint(1) DEFAULT 0,
  `examination_type` varchar(50) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `student_fees`
--

INSERT INTO `student_fees` (`id`, `student_id`, `fee_type`, `amount`, `month`, `academic_year`, `is_one_time`, `is_recurring`, `examination_type`, `notes`, `created_at`) VALUES
(73, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(74, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(75, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(76, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(77, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(78, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(79, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(80, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(81, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(82, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(83, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(84, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:04'),
(85, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(86, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(87, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(88, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(89, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(90, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(91, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(92, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(93, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(94, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(95, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(96, 29, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:04'),
(97, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(98, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(99, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(100, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(101, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(102, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(103, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(104, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(105, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(106, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(107, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(108, 31, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:31'),
(109, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(110, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(111, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(112, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(113, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(114, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(115, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(116, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(117, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(118, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(119, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(120, 31, 'examination', 3000.00, '0', '2025', 0, 0, 'other', '', '2025-11-25 18:40:31'),
(121, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(122, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(123, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(124, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(125, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(126, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(127, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(128, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(129, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(130, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(131, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(132, 32, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:40:54'),
(133, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(134, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(135, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(136, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(137, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(138, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(139, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(140, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(141, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(142, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(143, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(144, 32, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:40:54'),
(145, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(146, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(147, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(148, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(149, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(150, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(151, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(152, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(153, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(154, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(155, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(156, 33, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:41:14'),
(157, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(158, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(159, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(160, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(161, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(162, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(163, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(164, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(165, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(166, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(167, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(168, 33, 'examination', 3000.00, '0', '2025', 0, 0, 'mid_term', '', '2025-11-25 18:41:14'),
(169, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(170, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(171, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(172, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(173, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(174, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(175, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(176, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(177, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(178, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(179, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(180, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:42:39'),
(181, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(182, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(183, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(184, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(185, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(186, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(187, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(188, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(189, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(190, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(191, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(192, 29, 'monthly', 2000.00, '0', '2025', 0, 1, NULL, '', '2025-11-25 18:45:15'),
(193, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(194, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(195, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(196, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(197, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(198, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(199, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(200, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(201, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(202, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(203, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(204, 34, 'monthly', 300.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 16:53:47'),
(205, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15'),
(206, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15'),
(207, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15'),
(208, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15'),
(209, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15'),
(210, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15'),
(211, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15'),
(212, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15'),
(213, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15'),
(214, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15'),
(215, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15'),
(216, 35, 'monthly', 2500.00, '0', '2025', 0, 1, NULL, '', '2025-11-26 18:22:15');

-- --------------------------------------------------------

--
-- Table structure for table `student_fee_discounts`
--

CREATE TABLE `student_fee_discounts` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `head_id` int(11) DEFAULT NULL,
  `type` enum('fixed','percentage') NOT NULL,
  `value` decimal(5,2) NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `student_results`
--

CREATE TABLE `student_results` (
  `id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `total_marks_obtained` decimal(6,2) NOT NULL,
  `total_max_marks` int(6) NOT NULL,
  `percentage` decimal(5,2) NOT NULL,
  `grade` varchar(10) DEFAULT NULL,
  `result_status` enum('Pass','Fail','Promoted') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `subjects`
--

CREATE TABLE `subjects` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `code` varchar(20) DEFAULT NULL,
  `type` enum('core','elective','optional') DEFAULT 'core'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `subjects`
--

INSERT INTO `subjects` (`id`, `name`, `code`, `type`) VALUES
(7, 'Math', NULL, 'core'),
(8, 'Urdu', NULL, 'core'),
(9, 'English', NULL, 'core'),
(10, 'Islamiat', NULL, 'core'),
(11, 'Drawing', NULL, 'core');

-- --------------------------------------------------------

--
-- Table structure for table `teachers`
--

CREATE TABLE `teachers` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `emp_no` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `designation` varchar(50) DEFAULT NULL,
  `qualification` varchar(100) DEFAULT NULL,
  `cnic` varchar(15) DEFAULT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `salary` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` enum('active','inactive') DEFAULT 'active',
  `photo_path` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `teachers`
--

INSERT INTO `teachers` (`id`, `user_id`, `emp_no`, `name`, `designation`, `qualification`, `cnic`, `phone`, `joining_date`, `salary`, `status`, `photo_path`) VALUES
(1, NULL, '', 'Mubeshir Mehmood', 'Teacher', 'Graduate', '3840393218793', '03057442267', '2025-10-22', 5000.00, 'active', 'default.png');

-- --------------------------------------------------------

--
-- Table structure for table `teacher_deductions`
--

CREATE TABLE `teacher_deductions` (
  `id` int(11) NOT NULL,
  `slip_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `teacher_salary_items`
--

CREATE TABLE `teacher_salary_items` (
  `id` int(11) NOT NULL,
  `slip_id` int(11) NOT NULL,
  `item_type` enum('allowance','deduction','attendance') NOT NULL,
  `item_description` varchar(255) NOT NULL,
  `amount` decimal(10,2) NOT NULL DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `teacher_salary_items`
--

INSERT INTO `teacher_salary_items` (`id`, `slip_id`, `item_type`, `item_description`, `amount`) VALUES
(13, 12, 'allowance', 'Base Monthly Salary', 5000.00);

-- --------------------------------------------------------

--
-- Table structure for table `teacher_salary_slips`
--

CREATE TABLE `teacher_salary_slips` (
  `id` int(11) NOT NULL,
  `teacher_id` int(11) NOT NULL,
  `month_year` date NOT NULL COMMENT 'YYYY-MM-01 format',
  `gross_salary` decimal(10,2) NOT NULL DEFAULT 0.00,
  `total_deduction` decimal(10,2) NOT NULL DEFAULT 0.00,
  `total_deductions` decimal(10,2) NOT NULL DEFAULT 0.00,
  `net_paid` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` enum('generated','paid','cancelled') NOT NULL DEFAULT 'generated',
  `paid_date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `teacher_salary_slips`
--

INSERT INTO `teacher_salary_slips` (`id`, `teacher_id`, `month_year`, `gross_salary`, `total_deduction`, `total_deductions`, `net_paid`, `status`, `paid_date`, `created_at`) VALUES
(12, 1, '2025-11-01', 5000.00, 0.00, 0.00, 5000.00, 'generated', NULL, '2025-11-25 19:19:45');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `role_id` int(11) NOT NULL,
  `teacher_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `license_status` varchar(20) DEFAULT 'Active',
  `license_expiry_date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `password_hash`, `role_id`, `teacher_id`, `name`, `email`, `status`, `license_status`, `license_expiry_date`, `created_at`) VALUES
(1, 'admin', '$2y$10$9ntuHdgp6B5roT7ln3uP7u9PqrhgCm88YnNVzaG5r1UKl9vd4.6m.', 1, NULL, 'System Admin', NULL, 'active', 'Active', NULL, '2025-10-21 10:45:29'),
(8, 'abc', '$2y$10$uYCeohaW7G0mTzcpERncZuftnaMzCsrQJ.kKBL.GJ3aCJhxco7vdS', 5, NULL, 'abc', '', 'active', 'Active', NULL, '2025-11-13 15:52:09');

-- --------------------------------------------------------

--
-- Table structure for table `user_roles`
--

CREATE TABLE `user_roles` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user_roles`
--

INSERT INTO `user_roles` (`id`, `name`) VALUES
(1, 'Admin'),
(5, 'Parents');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `academic_classes`
--
ALTER TABLE `academic_classes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `academic_sections`
--
ALTER TABLE `academic_sections`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `academic_sessions`
--
ALTER TABLE `academic_sessions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `class_exam_structure`
--
ALTER TABLE `class_exam_structure`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `exam_id` (`exam_id`,`class_id`,`subject_id`),
  ADD UNIQUE KEY `unique_exam_class_subject` (`exam_id`,`class_id`,`subject_id`),
  ADD UNIQUE KEY `unique_exam_class_subject_new` (`exam_id`,`class_id`,`subject_id`),
  ADD UNIQUE KEY `unique_exam_class_subject_custom` (`exam_id`,`class_id`,`subject_id`),
  ADD KEY `class_id` (`class_id`),
  ADD KEY `subject_id` (`subject_id`);

--
-- Indexes for table `class_sections`
--
ALTER TABLE `class_sections`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`,`class_id`,`section_id`),
  ADD KEY `class_id` (`class_id`),
  ADD KEY `section_id` (`section_id`),
  ADD KEY `class_teacher_id` (`class_teacher_id`);

--
-- Indexes for table `class_syllabus`
--
ALTER TABLE `class_syllabus`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_class_syllabus` (`class_id`,`syllabus_type`,`academic_year`);

--
-- Indexes for table `course_allocation`
--
ALTER TABLE `course_allocation`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`,`class_id`,`section_id`,`subject_id`),
  ADD KEY `class_id` (`class_id`),
  ADD KEY `section_id` (`section_id`),
  ADD KEY `subject_id` (`subject_id`),
  ADD KEY `teacher_id` (`teacher_id`);

--
-- Indexes for table `daily_attendance_records`
--
ALTER TABLE `daily_attendance_records`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sheet_id` (`sheet_id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `daily_attendance_sheets`
--
ALTER TABLE `daily_attendance_sheets`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`,`class_id`,`section_id`,`attendance_date`),
  ADD KEY `recorded_by_teacher_id` (`recorded_by_teacher_id`),
  ADD KEY `section_id` (`section_id`);

--
-- Indexes for table `daily_planner`
--
ALTER TABLE `daily_planner`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_plan` (`class_id`,`section_id`,`subject_id`,`planner_date`);

--
-- Indexes for table `exams`
--
ALTER TABLE `exams`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`,`name`);

--
-- Indexes for table `exam_datesheet`
--
ALTER TABLE `exam_datesheet`
  ADD PRIMARY KEY (`exam_id`,`class_id`,`exam_date`);

--
-- Indexes for table `exam_marks`
--
ALTER TABLE `exam_marks`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `exam_id` (`exam_id`,`student_id`,`subject_id`),
  ADD KEY `student_id` (`student_id`),
  ADD KEY `subject_id` (`subject_id`);

--
-- Indexes for table `fee_heads`
--
ALTER TABLE `fee_heads`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `fee_invoices`
--
ALTER TABLE `fee_invoices`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `voucher_no` (`voucher_no`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `fee_invoice_items`
--
ALTER TABLE `fee_invoice_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoice_id` (`invoice_id`);

--
-- Indexes for table `fee_payments`
--
ALTER TABLE `fee_payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoice_id` (`invoice_id`),
  ADD KEY `received_by` (`received_by`);

--
-- Indexes for table `fee_structures`
--
ALTER TABLE `fee_structures`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`,`class_id`,`head_id`),
  ADD KEY `class_id` (`class_id`),
  ADD KEY `head_id` (`head_id`);

--
-- Indexes for table `notices`
--
ALTER TABLE `notices`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `other_expenses`
--
ALTER TABLE `other_expenses`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `parent_student_link`
--
ALTER TABLE `parent_student_link`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_parent_student` (`parent_user_id`,`student_id`);

--
-- Indexes for table `school_leaving_certificates`
--
ALTER TABLE `school_leaving_certificates`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_student_session` (`student_id`,`leaving_class_id`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`setting_key`);

--
-- Indexes for table `students`
--
ALTER TABLE `students`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `gr_no` (`gr_no`),
  ADD UNIQUE KEY `cnic_bform` (`cnic_bform`);

--
-- Indexes for table `student_enrollments`
--
ALTER TABLE `student_enrollments`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `student_id` (`student_id`,`session_id`),
  ADD KEY `session_id` (`session_id`),
  ADD KEY `class_id` (`class_id`),
  ADD KEY `section_id` (`section_id`);

--
-- Indexes for table `student_fees`
--
ALTER TABLE `student_fees`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `student_fee_discounts`
--
ALTER TABLE `student_fee_discounts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`),
  ADD KEY `head_id` (`head_id`);

--
-- Indexes for table `student_results`
--
ALTER TABLE `student_results`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `exam_id` (`exam_id`,`student_id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `subjects`
--
ALTER TABLE `subjects`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `teachers`
--
ALTER TABLE `teachers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `emp_no` (`emp_no`),
  ADD UNIQUE KEY `cnic` (`cnic`);

--
-- Indexes for table `teacher_deductions`
--
ALTER TABLE `teacher_deductions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `slip_id` (`slip_id`);

--
-- Indexes for table `teacher_salary_items`
--
ALTER TABLE `teacher_salary_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `slip_id` (`slip_id`);

--
-- Indexes for table `teacher_salary_slips`
--
ALTER TABLE `teacher_salary_slips`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_teacher_month` (`teacher_id`,`month_year`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `role_id` (`role_id`),
  ADD KEY `teacher_id` (`teacher_id`);

--
-- Indexes for table `user_roles`
--
ALTER TABLE `user_roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `academic_classes`
--
ALTER TABLE `academic_classes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `academic_sections`
--
ALTER TABLE `academic_sections`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `academic_sessions`
--
ALTER TABLE `academic_sessions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `class_exam_structure`
--
ALTER TABLE `class_exam_structure`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=58;

--
-- AUTO_INCREMENT for table `class_sections`
--
ALTER TABLE `class_sections`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `class_syllabus`
--
ALTER TABLE `class_syllabus`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `course_allocation`
--
ALTER TABLE `course_allocation`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `daily_attendance_records`
--
ALTER TABLE `daily_attendance_records`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=55;

--
-- AUTO_INCREMENT for table `daily_attendance_sheets`
--
ALTER TABLE `daily_attendance_sheets`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `daily_planner`
--
ALTER TABLE `daily_planner`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=65;

--
-- AUTO_INCREMENT for table `exams`
--
ALTER TABLE `exams`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `exam_marks`
--
ALTER TABLE `exam_marks`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=197;

--
-- AUTO_INCREMENT for table `fee_heads`
--
ALTER TABLE `fee_heads`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `fee_invoices`
--
ALTER TABLE `fee_invoices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=28;

--
-- AUTO_INCREMENT for table `fee_invoice_items`
--
ALTER TABLE `fee_invoice_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=140;

--
-- AUTO_INCREMENT for table `fee_payments`
--
ALTER TABLE `fee_payments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `fee_structures`
--
ALTER TABLE `fee_structures`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=29;

--
-- AUTO_INCREMENT for table `notices`
--
ALTER TABLE `notices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `other_expenses`
--
ALTER TABLE `other_expenses`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `parent_student_link`
--
ALTER TABLE `parent_student_link`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `school_leaving_certificates`
--
ALTER TABLE `school_leaving_certificates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `students`
--
ALTER TABLE `students`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=36;

--
-- AUTO_INCREMENT for table `student_enrollments`
--
ALTER TABLE `student_enrollments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=27;

--
-- AUTO_INCREMENT for table `student_fees`
--
ALTER TABLE `student_fees`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=217;

--
-- AUTO_INCREMENT for table `student_fee_discounts`
--
ALTER TABLE `student_fee_discounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `student_results`
--
ALTER TABLE `student_results`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `subjects`
--
ALTER TABLE `subjects`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `teachers`
--
ALTER TABLE `teachers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `teacher_deductions`
--
ALTER TABLE `teacher_deductions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `teacher_salary_items`
--
ALTER TABLE `teacher_salary_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `teacher_salary_slips`
--
ALTER TABLE `teacher_salary_slips`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `user_roles`
--
ALTER TABLE `user_roles`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `class_exam_structure`
--
ALTER TABLE `class_exam_structure`
  ADD CONSTRAINT `class_exam_structure_ibfk_1` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`),
  ADD CONSTRAINT `class_exam_structure_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `academic_classes` (`id`),
  ADD CONSTRAINT `class_exam_structure_ibfk_3` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`);

--
-- Constraints for table `class_sections`
--
ALTER TABLE `class_sections`
  ADD CONSTRAINT `class_sections_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `academic_sessions` (`id`),
  ADD CONSTRAINT `class_sections_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `academic_classes` (`id`),
  ADD CONSTRAINT `class_sections_ibfk_3` FOREIGN KEY (`section_id`) REFERENCES `academic_sections` (`id`),
  ADD CONSTRAINT `class_sections_ibfk_4` FOREIGN KEY (`class_teacher_id`) REFERENCES `teachers` (`id`);

--
-- Constraints for table `class_syllabus`
--
ALTER TABLE `class_syllabus`
  ADD CONSTRAINT `class_syllabus_ibfk_1` FOREIGN KEY (`class_id`) REFERENCES `academic_classes` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `course_allocation`
--
ALTER TABLE `course_allocation`
  ADD CONSTRAINT `course_allocation_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `academic_sessions` (`id`),
  ADD CONSTRAINT `course_allocation_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `academic_classes` (`id`),
  ADD CONSTRAINT `course_allocation_ibfk_3` FOREIGN KEY (`section_id`) REFERENCES `academic_sections` (`id`),
  ADD CONSTRAINT `course_allocation_ibfk_4` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`),
  ADD CONSTRAINT `course_allocation_ibfk_5` FOREIGN KEY (`teacher_id`) REFERENCES `teachers` (`id`);

--
-- Constraints for table `daily_attendance_records`
--
ALTER TABLE `daily_attendance_records`
  ADD CONSTRAINT `daily_attendance_records_ibfk_1` FOREIGN KEY (`sheet_id`) REFERENCES `daily_attendance_sheets` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `daily_attendance_records_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`);

--
-- Constraints for table `daily_attendance_sheets`
--
ALTER TABLE `daily_attendance_sheets`
  ADD CONSTRAINT `daily_attendance_sheets_ibfk_1` FOREIGN KEY (`recorded_by_teacher_id`) REFERENCES `teachers` (`id`),
  ADD CONSTRAINT `daily_attendance_sheets_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `academic_sections` (`id`);

--
-- Constraints for table `exams`
--
ALTER TABLE `exams`
  ADD CONSTRAINT `exams_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `academic_sessions` (`id`);

--
-- Constraints for table `exam_marks`
--
ALTER TABLE `exam_marks`
  ADD CONSTRAINT `exam_marks_ibfk_1` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`),
  ADD CONSTRAINT `exam_marks_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`),
  ADD CONSTRAINT `exam_marks_ibfk_3` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`);

--
-- Constraints for table `fee_invoices`
--
ALTER TABLE `fee_invoices`
  ADD CONSTRAINT `fee_invoices_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fee_invoices_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fee_invoices_ibfk_3` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fee_invoices_ibfk_4` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fee_invoices_ibfk_5` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `fee_invoice_items`
--
ALTER TABLE `fee_invoice_items`
  ADD CONSTRAINT `fee_invoice_items_ibfk_1` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fee_invoice_items_ibfk_2` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fee_invoice_items_ibfk_3` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fee_invoice_items_ibfk_4` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fee_invoice_items_ibfk_5` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `fee_payments`
--
ALTER TABLE `fee_payments`
  ADD CONSTRAINT `fee_payments_ibfk_1` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`),
  ADD CONSTRAINT `fee_payments_ibfk_2` FOREIGN KEY (`received_by`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `fee_payments_ibfk_3` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fee_payments_ibfk_4` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fee_payments_ibfk_5` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fee_payments_ibfk_6` FOREIGN KEY (`invoice_id`) REFERENCES `fee_invoices` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `fee_structures`
--
ALTER TABLE `fee_structures`
  ADD CONSTRAINT `fee_structures_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `academic_sessions` (`id`),
  ADD CONSTRAINT `fee_structures_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `academic_classes` (`id`),
  ADD CONSTRAINT `fee_structures_ibfk_3` FOREIGN KEY (`head_id`) REFERENCES `fee_heads` (`id`);

--
-- Constraints for table `parent_student_link`
--
ALTER TABLE `parent_student_link`
  ADD CONSTRAINT `parent_student_link_ibfk_1` FOREIGN KEY (`parent_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `student_enrollments`
--
ALTER TABLE `student_enrollments`
  ADD CONSTRAINT `student_enrollments_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`),
  ADD CONSTRAINT `student_enrollments_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `academic_sessions` (`id`),
  ADD CONSTRAINT `student_enrollments_ibfk_3` FOREIGN KEY (`class_id`) REFERENCES `academic_classes` (`id`),
  ADD CONSTRAINT `student_enrollments_ibfk_4` FOREIGN KEY (`section_id`) REFERENCES `academic_sections` (`id`);

--
-- Constraints for table `student_fees`
--
ALTER TABLE `student_fees`
  ADD CONSTRAINT `student_fees_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `student_fees_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `student_fees_ibfk_3` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `student_fees_ibfk_4` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `student_fee_discounts`
--
ALTER TABLE `student_fee_discounts`
  ADD CONSTRAINT `student_fee_discounts_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`),
  ADD CONSTRAINT `student_fee_discounts_ibfk_2` FOREIGN KEY (`head_id`) REFERENCES `fee_heads` (`id`);

--
-- Constraints for table `student_results`
--
ALTER TABLE `student_results`
  ADD CONSTRAINT `student_results_ibfk_1` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`),
  ADD CONSTRAINT `student_results_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`);

--
-- Constraints for table `teacher_deductions`
--
ALTER TABLE `teacher_deductions`
  ADD CONSTRAINT `teacher_deductions_ibfk_1` FOREIGN KEY (`slip_id`) REFERENCES `teacher_salary_slips` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `teacher_salary_items`
--
ALTER TABLE `teacher_salary_items`
  ADD CONSTRAINT `teacher_salary_items_ibfk_1` FOREIGN KEY (`slip_id`) REFERENCES `teacher_salary_slips` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `teacher_salary_slips`
--
ALTER TABLE `teacher_salary_slips`
  ADD CONSTRAINT `teacher_salary_slips_ibfk_1` FOREIGN KEY (`teacher_id`) REFERENCES `teachers` (`id`);

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `user_roles` (`id`),
  ADD CONSTRAINT `users_ibfk_2` FOREIGN KEY (`teacher_id`) REFERENCES `teachers` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
